/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableChannelDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;

public class EnableChannelDialog
extends Dialog
implements IEnableChannelDialog {
    public static final String ENABLE_CHANNEL_ICON_FILE = "icons/elcl16/add_button.gif";
    private static final String DEFAULT_TEXT = "<" + Messages.EnableChannelDialog_DefaultMessage + ">";
    private Text fChannelNameText = null;
    private Button fDiscardModeButton = null;
    private Button fOverwriteModeButton = null;
    private Text fSubBufferSizeText = null;
    private Text fNumberOfSubBuffersText = null;
    private Text fSwitchTimerText = null;
    private Text fReadTimerText = null;
    private Button fKernelButton = null;
    private Button fUstButton = null;
    private TraceDomainComponent fDomainComponent = null;
    private TargetNodeComponent fTargetNodeComponent = null;
    private VerifyListener fVerifyListener = null;
    private FocusListener fFocusListener = null;
    private IChannelInfo fChannelInfo = null;
    private TraceDomainType fDomain = TraceDomainType.KERNEL;
    private boolean fHasKernel;
    private Text fMaxSizeTraceText = null;
    private Text fMaxNumberTraceText = null;
    private Button fSharedBuffersButton = null;
    private Button fPIDBuffersButton = null;
    private Button fUIDBuffersButton = null;
    private Button fMetadataChannelButton = null;
    private String fPreviousChannelName = null;

    public EnableChannelDialog(Shell shell) {
        super(shell);
        this.fVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*") || e.text.matches(DEFAULT_TEXT);
            }
        };
        this.fFocusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                Text focusLostWidget = (Text)e.widget;
                if (focusLostWidget.getText().isEmpty()) {
                    focusLostWidget.setText(DEFAULT_TEXT);
                    focusLostWidget.setForeground(EnableChannelDialog.this.getShell().getDisplay().getSystemColor(15));
                }
            }

            public void focusGained(FocusEvent e) {
                Text focusGainedWidget = (Text)e.widget;
                if (focusGainedWidget.getText().equals(DEFAULT_TEXT)) {
                    focusGainedWidget.setText("");
                    focusGainedWidget.setForeground(EnableChannelDialog.this.getShell().getDisplay().getSystemColor(2));
                }
            }
        };
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public IChannelInfo getChannelInfo() {
        return this.fChannelInfo;
    }

    @Override
    public void setDomainComponent(TraceDomainComponent domain) {
        this.fDomainComponent = domain;
        this.fDomain = this.fDomainComponent != null ? this.fDomainComponent.getDomain() : TraceDomainType.KERNEL;
    }

    @Override
    public TraceDomainType getDomain() {
        return this.fDomain;
    }

    @Override
    public void setHasKernel(boolean hasKernel) {
        this.fDomain = this.fDomainComponent != null ? this.fDomainComponent.getDomain() : (hasKernel ? TraceDomainType.KERNEL : TraceDomainType.UST);
        this.fHasKernel = hasKernel;
    }

    @Override
    public void setTargetNodeComponent(TargetNodeComponent node) {
        this.fTargetNodeComponent = node;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_EnableChannelDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(ENABLE_CHANNEL_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        int numColumn = 2;
        if (this.fTargetNodeComponent.isBufferTypeConfigSupported()) {
            numColumn = 3;
        }
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogComposite.setLayout((Layout)layout);
        Composite commonModeGroup = new Composite(dialogComposite, 0);
        layout = new GridLayout(3, true);
        commonModeGroup.setLayout((Layout)layout);
        Label channelNameLabel = new Label(commonModeGroup, 131072);
        channelNameLabel.setText(Messages.TraceControl_EnableChannelNameLabel);
        this.fChannelNameText = new Text(commonModeGroup, 0);
        this.fChannelNameText.setToolTipText(Messages.TraceControl_EnableChannelNameTooltip);
        Label subBufferSizeLabel = new Label(commonModeGroup, 131072);
        subBufferSizeLabel.setText(Messages.TraceControl_SubBufferSizePropertyName);
        this.fSubBufferSizeText = new Text(commonModeGroup, 0);
        this.fSubBufferSizeText.setToolTipText(Messages.TraceControl_EnableChannelSubBufferSizeTooltip);
        this.fSubBufferSizeText.addVerifyListener(this.fVerifyListener);
        this.fSubBufferSizeText.addFocusListener(this.fFocusListener);
        this.fSubBufferSizeText.setForeground(this.getShell().getDisplay().getSystemColor(15));
        Label numSubBufferLabel = new Label(commonModeGroup, 131072);
        numSubBufferLabel.setText(Messages.TraceControl_NbSubBuffersPropertyName);
        this.fNumberOfSubBuffersText = new Text(commonModeGroup, 0);
        this.fNumberOfSubBuffersText.setToolTipText(Messages.TraceControl_EnableChannelNbSubBuffersTooltip);
        this.fNumberOfSubBuffersText.addVerifyListener(this.fVerifyListener);
        this.fNumberOfSubBuffersText.addFocusListener(this.fFocusListener);
        Label switchTimerLabel = new Label(commonModeGroup, 131072);
        switchTimerLabel.setText(Messages.TraceControl_SwitchTimerPropertyName);
        this.fSwitchTimerText = new Text(commonModeGroup, 0);
        this.fSwitchTimerText.setToolTipText(Messages.TraceControl_EnableChannelSwitchTimerTooltip);
        this.fSwitchTimerText.addVerifyListener(this.fVerifyListener);
        this.fSwitchTimerText.addFocusListener(this.fFocusListener);
        Label readTimerLabel = new Label(commonModeGroup, 131072);
        readTimerLabel.setText(Messages.TraceControl_ReadTimerPropertyName);
        this.fReadTimerText = new Text(commonModeGroup, 0);
        this.fReadTimerText.setToolTipText(Messages.TraceControl_EnableChannelReadTimerTooltip);
        this.fReadTimerText.addVerifyListener(this.fVerifyListener);
        this.fReadTimerText.addFocusListener(this.fFocusListener);
        if (this.fTargetNodeComponent.isTraceFileRotationSupported()) {
            Label maxSizeTraceFilesLabel = new Label(commonModeGroup, 131072);
            maxSizeTraceFilesLabel.setText(Messages.TraceControl_MaxSizeTraceFilesPropertyName);
            this.fMaxSizeTraceText = new Text(commonModeGroup, 0);
            this.fMaxSizeTraceText.setToolTipText(Messages.TraceControl_EnbleChannelMaxSizeTraceFilesTooltip);
            this.fMaxSizeTraceText.addVerifyListener(this.fVerifyListener);
            this.fMaxSizeTraceText.addFocusListener(this.fFocusListener);
            Label maxNumTraceFilesLabel = new Label(commonModeGroup, 131072);
            maxNumTraceFilesLabel.setText(Messages.TraceControl_MaxNumTraceFilesPropertyName);
            this.fMaxNumberTraceText = new Text(commonModeGroup, 0);
            this.fMaxNumberTraceText.setToolTipText(Messages.TraceControl_EnbleChannelMaxNumTraceFilesTooltip);
            this.fMaxNumberTraceText.addVerifyListener(this.fVerifyListener);
            this.fMaxNumberTraceText.addFocusListener(this.fFocusListener);
        }
        if (this.fTargetNodeComponent.isPeriodicalMetadataFlushSupported()) {
            this.fMetadataChannelButton = new Button(commonModeGroup, 32);
            this.fMetadataChannelButton.setText(Messages.TraceControl_ConfigureMetadataChannelName);
            this.fMetadataChannelButton.setSelection(false);
            this.fMetadataChannelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (EnableChannelDialog.this.fMetadataChannelButton.getSelection()) {
                        EnableChannelDialog.this.fPreviousChannelName = EnableChannelDialog.this.fChannelNameText.getText();
                        EnableChannelDialog.this.fChannelNameText.setText("metadata");
                        EnableChannelDialog.this.fChannelNameText.setEnabled(false);
                    } else {
                        EnableChannelDialog.this.fChannelNameText.setText(EnableChannelDialog.this.fPreviousChannelName);
                        EnableChannelDialog.this.fChannelNameText.setEnabled(true);
                    }
                }
            });
        }
        Group discardModeGroup = new Group(dialogComposite, 32);
        discardModeGroup.setText(Messages.TraceControl_EnableChannelDiscardModeGroupName);
        layout = new GridLayout(numColumn, true);
        discardModeGroup.setLayout((Layout)layout);
        this.fDiscardModeButton = new Button((Composite)discardModeGroup, 16);
        this.fDiscardModeButton.setText(Messages.TraceControl_EnableChannelDiscardModeLabel);
        this.fDiscardModeButton.setToolTipText(Messages.TraceControl_EnableChannelDiscardModeTooltip);
        this.fDiscardModeButton.setSelection(true);
        this.fOverwriteModeButton = new Button((Composite)discardModeGroup, 16);
        this.fOverwriteModeButton.setText(Messages.TraceControl_EnableChannelOverwriteModeLabel);
        this.fOverwriteModeButton.setToolTipText(Messages.TraceControl_EnableChannelOverwriteModeTooltip);
        this.fOverwriteModeButton.setSelection(false);
        Group domainGroup = new Group(dialogComposite, 32);
        domainGroup.setText(Messages.TraceControl_DomainDisplayName);
        layout = new GridLayout(numColumn, true);
        domainGroup.setLayout((Layout)layout);
        this.fKernelButton = new Button((Composite)domainGroup, 16);
        this.fKernelButton.setText(Messages.TraceControl_KernelDomainDisplayName);
        this.fKernelButton.setSelection(this.fDomain.equals((Object)TraceDomainType.KERNEL));
        this.fUstButton = new Button((Composite)domainGroup, 16);
        this.fUstButton.setText(Messages.TraceControl_UstDisplayName);
        this.fUstButton.setSelection(this.fDomain.equals((Object)TraceDomainType.UST));
        if (this.fTargetNodeComponent.isBufferTypeConfigSupported()) {
            Group bufferTypeGroup = new Group(dialogComposite, 32);
            bufferTypeGroup.setText(Messages.TraceControl_BufferTypeDisplayName);
            layout = new GridLayout(numColumn, true);
            bufferTypeGroup.setLayout((Layout)layout);
            GridData data = new GridData(4, 1, false, false);
            data.horizontalSpan = 3;
            bufferTypeGroup.setLayoutData((Object)data);
            this.fSharedBuffersButton = new Button((Composite)bufferTypeGroup, 16);
            this.fSharedBuffersButton.setText(Messages.TraceControl_SharedBuffersDisplayName);
            this.fSharedBuffersButton.setSelection(this.fDomain.equals((Object)TraceDomainType.KERNEL));
            this.fSharedBuffersButton.setEnabled(false);
            this.fPIDBuffersButton = new Button((Composite)bufferTypeGroup, 16);
            this.fPIDBuffersButton.setText(Messages.TraceControl_PerPidBuffersDisplayName);
            this.fPIDBuffersButton.setToolTipText(Messages.TraceControl_PerPidBuffersTooltip);
            this.fPIDBuffersButton.setSelection(false);
            this.fUIDBuffersButton = new Button((Composite)bufferTypeGroup, 16);
            this.fUIDBuffersButton.setText(Messages.TraceControl_PerUidBuffersDisplayName);
            this.fUIDBuffersButton.setToolTipText(Messages.TraceControl_PerPidBuffersTooltip);
            this.fUIDBuffersButton.setSelection(false);
            this.fUIDBuffersButton.setEnabled(this.fDomain.equals((Object)TraceDomainType.UST));
            this.fPIDBuffersButton.setEnabled(this.fDomain.equals((Object)TraceDomainType.UST));
            this.fUstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (EnableChannelDialog.this.fUstButton.getSelection()) {
                        EnableChannelDialog.this.fSharedBuffersButton.setSelection(false);
                        EnableChannelDialog.this.fPIDBuffersButton.setSelection(false);
                        EnableChannelDialog.this.fUIDBuffersButton.setSelection(false);
                        EnableChannelDialog.this.fPIDBuffersButton.setEnabled(true);
                        EnableChannelDialog.this.fUIDBuffersButton.setEnabled(true);
                    } else {
                        EnableChannelDialog.this.fSharedBuffersButton.setSelection(true);
                        EnableChannelDialog.this.fPIDBuffersButton.setSelection(false);
                        EnableChannelDialog.this.fUIDBuffersButton.setSelection(false);
                        EnableChannelDialog.this.fPIDBuffersButton.setEnabled(false);
                        EnableChannelDialog.this.fUIDBuffersButton.setEnabled(false);
                    }
                }
            });
        }
        if (this.fDomainComponent != null || !this.fHasKernel) {
            this.fKernelButton.setEnabled(false);
            this.fUstButton.setEnabled(false);
            if (this.fTargetNodeComponent.isBufferTypeConfigSupported()) {
                this.fSharedBuffersButton.setEnabled(false);
                this.fUIDBuffersButton.setEnabled(!this.fHasKernel);
                this.fPIDBuffersButton.setEnabled(!this.fHasKernel);
                this.setBufferTypeButtonSelection();
            }
        }
        GridData data = new GridData(4, 1, false, false);
        data.horizontalSpan = 3;
        discardModeGroup.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fDiscardModeButton.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fOverwriteModeButton.setLayoutData((Object)data);
        data = new GridData(4, 1, false, false);
        data.horizontalSpan = 3;
        domainGroup.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fKernelButton.setLayoutData((Object)data);
        data = new GridData(1, 1, true, true);
        this.fUstButton.setLayoutData((Object)data);
        if (this.fTargetNodeComponent.isBufferTypeConfigSupported()) {
            data = new GridData(1, 1, true, true);
            this.fSharedBuffersButton.setLayoutData((Object)data);
            data = new GridData(1, 1, true, true);
            this.fPIDBuffersButton.setLayoutData((Object)data);
            data = new GridData(1, 1, true, true);
            this.fUIDBuffersButton.setLayoutData((Object)data);
        }
        if (this.fTargetNodeComponent.isPeriodicalMetadataFlushSupported()) {
            data = new GridData(1, 1, true, true);
            data.horizontalSpan = numColumn;
            this.fMetadataChannelButton.setLayoutData((Object)data);
        }
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.fChannelNameText.setLayoutData((Object)data);
        this.fSubBufferSizeText.setLayoutData((Object)data);
        this.fNumberOfSubBuffersText.setLayoutData((Object)data);
        this.fSwitchTimerText.setLayoutData((Object)data);
        this.fReadTimerText.setLayoutData((Object)data);
        if (this.fTargetNodeComponent.isTraceFileRotationSupported()) {
            this.fMaxNumberTraceText.setLayoutData((Object)data);
            this.fMaxSizeTraceText.setLayoutData((Object)data);
        }
        this.setDefaults();
        return dialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 13, "&Default", true);
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        ChannelInfo channelInfo = new ChannelInfo(this.fChannelNameText.getText());
        channelInfo.setSubBufferSize(this.fSubBufferSizeText.getText().equals(DEFAULT_TEXT) ? -1L : Long.parseLong(this.fSubBufferSizeText.getText()));
        channelInfo.setNumberOfSubBuffers(this.fNumberOfSubBuffersText.getText().equals(DEFAULT_TEXT) ? -1 : Integer.parseInt(this.fNumberOfSubBuffersText.getText()));
        channelInfo.setSwitchTimer(this.fSwitchTimerText.getText().equals(DEFAULT_TEXT) ? -1L : Long.parseLong(this.fSwitchTimerText.getText()));
        channelInfo.setReadTimer(this.fReadTimerText.getText().equals(DEFAULT_TEXT) ? -1L : Long.parseLong(this.fReadTimerText.getText()));
        channelInfo.setOverwriteMode(this.fOverwriteModeButton.getSelection());
        if (this.fTargetNodeComponent.isTraceFileRotationSupported()) {
            channelInfo.setMaxSizeTraceFiles((long)(this.fMaxSizeTraceText.getText().equals(DEFAULT_TEXT) ? -1 : Integer.parseInt(this.fMaxSizeTraceText.getText())));
            channelInfo.setMaxNumberTraceFiles(this.fMaxNumberTraceText.getText().equals(DEFAULT_TEXT) ? -1 : Integer.parseInt(this.fMaxNumberTraceText.getText()));
        }
        if (this.fTargetNodeComponent.isBufferTypeConfigSupported()) {
            if (this.fSharedBuffersButton.getSelection()) {
                channelInfo.setBufferType(BufferType.BUFFER_SHARED);
            } else if (this.fPIDBuffersButton.getSelection()) {
                channelInfo.setBufferType(BufferType.BUFFER_PER_PID);
            } else if (this.fUIDBuffersButton.getSelection()) {
                channelInfo.setBufferType(BufferType.BUFFER_PER_UID);
            } else {
                channelInfo.setBufferType(BufferType.BUFFER_TYPE_UNKNOWN);
            }
        }
        if (this.fKernelButton.getSelection()) {
            this.fDomain = TraceDomainType.KERNEL;
        } else if (this.fUstButton.getSelection()) {
            this.fDomain = TraceDomainType.UST;
        }
        if (!channelInfo.getName().matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableChannelDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidChannelNameError) + " (" + channelInfo.getName() + ") \n"));
            return;
        }
        if (this.fDomainComponent != null && this.fDomainComponent.containsChild(channelInfo.getName())) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableChannelDialogTitle, (String)(String.valueOf(Messages.TraceControl_ChannelAlreadyExistsError) + " (" + channelInfo.getName() + ") \n"));
            return;
        }
        this.fChannelInfo = channelInfo;
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            this.setDefaults();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void setDefaults() {
        this.fSwitchTimerText.setText(DEFAULT_TEXT);
        this.fSwitchTimerText.setForeground(this.getShell().getDisplay().getSystemColor(15));
        this.fReadTimerText.setText(DEFAULT_TEXT);
        this.fReadTimerText.setForeground(this.getShell().getDisplay().getSystemColor(15));
        this.fOverwriteModeButton.setSelection(false);
        if (this.fTargetNodeComponent.isTraceFileRotationSupported()) {
            this.fMaxSizeTraceText.setText(DEFAULT_TEXT);
            this.fMaxSizeTraceText.setForeground(this.getShell().getDisplay().getSystemColor(15));
            this.fMaxNumberTraceText.setText(DEFAULT_TEXT);
            this.fMaxNumberTraceText.setForeground(this.getShell().getDisplay().getSystemColor(15));
        }
        this.fSubBufferSizeText.setText(DEFAULT_TEXT);
        this.fSubBufferSizeText.setForeground(this.getShell().getDisplay().getSystemColor(15));
        this.fNumberOfSubBuffersText.setText(DEFAULT_TEXT);
        this.fNumberOfSubBuffersText.setForeground(this.getShell().getDisplay().getSystemColor(15));
        if (this.fTargetNodeComponent.isBufferTypeConfigSupported()) {
            this.setBufferTypeButtonSelection();
        }
    }

    private void setBufferTypeButtonSelection() {
        if (this.fDomainComponent != null && this.fDomainComponent.getBufferType() != null) {
            switch (this.fDomainComponent.getBufferType()) {
                case BUFFER_PER_PID: {
                    this.fPIDBuffersButton.setSelection(true);
                    break;
                }
                case BUFFER_PER_UID: {
                    this.fUIDBuffersButton.setSelection(true);
                    break;
                }
                case BUFFER_SHARED: {
                    this.fSharedBuffersButton.setSelection(true);
                    break;
                }
            }
        }
    }
}

