/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.handler.AbstractCommandHandler;

public abstract class AbstractPeerNodeCommandHandler
extends AbstractCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        List<IPeerNode> peerNodes = this.getPeerNodes(selection);
        return this.internalExecute(event, selection, peerNodes);
    }

    protected List<IPeerNode> getPeerNodes(IStructuredSelection selection) {
        ArrayList<IPeerNode> peerNodes = new ArrayList<IPeerNode>();
        for (Object element : selection) {
            IPeerNode peerNode = this.getPeerNode(element);
            if (peerNode == null || peerNodes.contains(peerNode)) continue;
            peerNodes.add(peerNode);
        }
        return peerNodes;
    }

    protected IPeerNode getPeerNode(Object element) {
        IPeerNode peerNode = null;
        if (element instanceof IPeerNode) {
            peerNode = (IPeerNode)element;
        } else if (element instanceof IAdaptable) {
            peerNode = (IPeerNode)((IAdaptable)element).getAdapter(IPeerNode.class);
        }
        if (peerNode == null) {
            peerNode = (IPeerNode)Platform.getAdapterManager().getAdapter(element, IPeerNode.class);
        }
        return peerNode;
    }

    protected abstract Object internalExecute(ExecutionEvent var1, IStructuredSelection var2, List<IPeerNode> var3);
}

