/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.util;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectionHelper {
    private SelectionHelper() {
    }

    public static final ISelectionService getSelectionService() {
        IWorkbenchWindow ww;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (ww = wb.getActiveWorkbenchWindow()) != null) {
            return (ISelectionService)ww.getService(ISelectionService.class);
        }
        return null;
    }

    public static final ISelection getCurrentSelection() {
        ISelection currentSelection;
        ISelectionService selectionService = SelectionHelper.getSelectionService();
        if (selectionService != null && (currentSelection = selectionService.getSelection()) != null) {
            return currentSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public static final ISelection getCurrentSelection(String viewId) {
        ISelection currentSelection;
        ISelectionService selectionService = SelectionHelper.getSelectionService();
        if (selectionService != null && (currentSelection = selectionService.getSelection(viewId)) != null) {
            return currentSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public static final IStructuredSelection getCurrentStructuredSelection() {
        ISelection selection = SelectionHelper.getCurrentSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static final IStructuredSelection getCurrentStructuredSelection(String viewId) {
        ISelection selection = SelectionHelper.getCurrentSelection(viewId);
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }
}

