/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editor;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelMngr;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IPageModelFactory;
import org.eclipse.papyrus.infra.core.services.IServiceFactory;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editorsfactory.PageModelFactoryRegistry;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.PluggableEditorFactoryReader;

public class DiSashModelMngrServiceFactory
implements IServiceFactory {
    private TransactionalEditingDomain transactionalEditingDomain;
    private SashModel sashModel;
    private DiSashModelMngr sashModelMngr;
    private ServicesRegistry servicesRegistry;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
        this.transactionalEditingDomain = (TransactionalEditingDomain)servicesRegistry.getService(TransactionalEditingDomain.class);
        this.sashModel = SashModelUtils.getSashModelChecked((ServicesRegistry)servicesRegistry);
    }

    public void startService() throws ServiceException {
        PageModelFactoryRegistry pageModelRegistry = new PageModelFactoryRegistry();
        PluggableEditorFactoryReader editorReader = new PluggableEditorFactoryReader("org.eclipse.papyrus.infra.ui");
        editorReader.populate(pageModelRegistry, this.servicesRegistry);
        if (this.sashModel.getResource() == null) {
            throw new ServiceException("Can't start " + this.getClass().getSimpleName() + "'. Required model (SashModel) should be loaded prior starting the service.");
        }
        this.sashModelMngr = new DiSashModelMngr((IPageModelFactory)pageModelRegistry, this.sashModel.getResource());
    }

    public void disposeService() throws ServiceException {
    }

    public Object createServiceInstance() throws ServiceException {
        if (this.sashModelMngr == null) {
            this.startService();
        }
        return this.sashModelMngr;
    }
}

