/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.exporter.junit;

import java.util.List;
import org.eclipse.jubula.client.core.exporter.junitmodel.ObjectFactory;
import org.eclipse.jubula.client.core.exporter.junitmodel.Testsuite;
import org.eclipse.jubula.client.core.exporter.junitmodel.Testsuites;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ITestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

public class SuiteFinderOperation
implements ITreeNodeOperation<TestResultNode> {
    private TestResultNode m_testRes;
    private Testsuites m_project;
    private List<TestResultNode> m_suiteList;
    private ITestResult m_testResult;

    public SuiteFinderOperation(TestResultNode testRes, Testsuites project, List<TestResultNode> list, ITestResult testResult) {
        this.setTestRes(testRes);
        this.setProject(project);
        this.setSuiteList(list);
        this.setTestresult(testResult);
    }

    private void setTestresult(ITestResult testRes2) {
        this.m_testResult = testRes2;
    }

    public boolean operate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
        if (node instanceof ICapPO) {
            return false;
        }
        if (node.isJunitTestSuite()) {
            this.createAndAddTestSuite(node);
            return false;
        }
        return true;
    }

    private void createAndAddTestSuite(TestResultNode node) {
        ObjectFactory obF = new ObjectFactory();
        Testsuite suite = obF.createTestsuite();
        suite.setName(node.getName());
        if (node.getTimeStamp() != null) {
            suite.setTimestamp(node.getTimeStamp().toString());
            suite.setTime(this.convertTime(node.getDuration(this.m_testResult.getEndTime())));
        }
        this.m_suiteList.add(node);
        this.m_project.getTestsuite().add(suite);
    }

    private String convertTime(long l) {
        String convertedtime = Double.toString((double)l / 1000.0);
        return convertedtime;
    }

    public void postOperate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
    }

    public TestResultNode getTestRes() {
        return this.m_testRes;
    }

    public void setTestRes(TestResultNode testResult) {
        this.m_testRes = testResult;
    }

    public Testsuites getProject() {
        return this.m_project;
    }

    public void setProject(Testsuites project) {
        this.m_project = project;
    }

    public List<TestResultNode> getSuiteList() {
        return this.m_suiteList;
    }

    public void setSuiteList(List<TestResultNode> suiteList) {
        this.m_suiteList = suiteList;
    }
}

