/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt.cocoa;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.ArrangeWindowHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.CloseDialogHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.CocoaUIHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.FullscreenWindowHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.MinimizeWindowHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.ZoomWindowHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CocoaUIProcessor {
    static final String FRAGMENT_ID = "org.eclipse.e4.ui.workbench.renderers.swt.cocoa";
    protected static final String CONTRIBUTOR_URI = "platform:/fragment/org.eclipse.e4.ui.workbench.renderers.swt.cocoa";
    static final String HOST_ID = "org.eclipse.e4.ui.workbench.renderers.swt";
    protected static final String CONTRIBUTION_URI_PREFIX = "bundleclass://org.eclipse.e4.ui.workbench.renderers.swt";
    private static final String COMMAND_ID_CLOSE_DIALOG = "org.eclipse.ui.cocoa.closeDialog";
    private static final String CLOSE_DIALOG_KEYSEQUENCE = "M1+W";
    @Inject
    protected MApplication app;
    @Inject
    protected Provider<StatusReporter> statusReporter;

    @Execute
    public void execute() {
        this.installAddon();
        this.installWindowHandlers();
        this.installCloseDialogHandlers();
    }

    public void installAddon() {
        MAddon addon2;
        String addonId = CocoaUIHandler.class.getName();
        for (MAddon addon2 : this.app.getAddons()) {
            if (!addonId.equals(addon2.getElementId())) continue;
            return;
        }
        addon2 = MApplicationFactory.INSTANCE.createAddon();
        addon2.setContributionURI(this.getClassURI(CocoaUIHandler.class));
        addon2.setElementId(addonId);
        this.app.getAddons().add(addon2);
    }

    public void installWindowHandlers() {
        this.installHandler(this.defineCommand("org.eclipse.ui.category.window", "org.eclipse.ui.cocoa.arrangeWindowsInFront", "%command.arrangeWindows.name", "%command.arrangeWindows.desc", CONTRIBUTOR_URI), ArrangeWindowHandler.class, CONTRIBUTOR_URI);
        this.installHandler(this.defineCommand("org.eclipse.ui.category.window", "org.eclipse.ui.cocoa.minimizeWindow", "%command.minimize.name", "%command.minimize.desc", CONTRIBUTOR_URI), MinimizeWindowHandler.class, CONTRIBUTOR_URI);
        MCommand toggleFullscreenCommand = this.defineCommand("org.eclipse.ui.category.window", "org.eclipse.ui.cocoa.fullscreenWindow", "%command.fullscreen.name", "%command.fullscreen.desc", CONTRIBUTOR_URI);
        this.installHandler(toggleFullscreenCommand, FullscreenWindowHandler.class, CONTRIBUTOR_URI);
        this.installKeybinding("org.eclipse.ui.contexts.window", "COMMAND+CTRL+F", toggleFullscreenCommand);
        this.installHandler(this.defineCommand("org.eclipse.ui.category.window", "org.eclipse.ui.cocoa.zoomWindow", "%command.zoom.name", "%command.zoom.desc", CONTRIBUTOR_URI), ZoomWindowHandler.class, CONTRIBUTOR_URI);
    }

    private void installCloseDialogHandlers() {
        MCommand closeDialogCommand = this.defineCommand("org.eclipse.ui.category.window", COMMAND_ID_CLOSE_DIALOG, "%command.closeDialog.name", "%command.closeDialog.desc", CONTRIBUTOR_URI);
        this.installHandler(closeDialogCommand, CloseDialogHandler.class, CONTRIBUTOR_URI);
        this.installKeybinding("org.eclipse.ui.contexts.dialog", CLOSE_DIALOG_KEYSEQUENCE, closeDialogCommand);
    }

    private void installKeybinding(String bindingContextId, String keysequence, MCommand cmd) {
        MBindingTable bindingTable = null;
        for (MBindingTable table : this.app.getBindingTables()) {
            for (MKeyBinding binding : table.getBindings()) {
                if (binding.getCommand() != cmd) continue;
                return;
            }
            if (table.getBindingContext() == null || !bindingContextId.equals(table.getBindingContext().getElementId())) continue;
            bindingTable = table;
        }
        if (bindingTable == null) {
            MBindingContext bindingContext = this.findBindingContext(this.app.getBindingContexts(), bindingContextId);
            if (bindingContext == null) {
                ((StatusReporter)this.statusReporter.get()).report((IStatus)new Status(2, FRAGMENT_ID, "No binding context exists for " + bindingContextId), 32, new Object[0]);
                return;
            }
            bindingTable = MCommandsFactory.INSTANCE.createBindingTable();
            bindingTable.setBindingContext(bindingContext);
            bindingTable.setContributorURI(CONTRIBUTOR_URI);
            this.app.getBindingTables().add(bindingTable);
        }
        MKeyBinding binding = MCommandsFactory.INSTANCE.createKeyBinding();
        binding.setCommand(cmd);
        binding.setKeySequence(keysequence);
        bindingTable.getBindings().add(binding);
    }

    private MBindingContext findBindingContext(List<MBindingContext> bindingContexts, String bindingContextId) {
        for (MBindingContext bc : bindingContexts) {
            if (bindingContextId.equals(bc.getElementId())) {
                return bc;
            }
            MBindingContext result = this.findBindingContext(bc.getChildren(), bindingContextId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void installHandler(MCommand command, Class<?> handlerClass, String contributorURI) {
        MHandler handler2;
        for (MHandler handler2 : this.app.getHandlers()) {
            if (!handlerClass.getName().equals(handler2.getElementId()) || handler2.getCommand() != command) continue;
            return;
        }
        handler2 = MCommandsFactory.INSTANCE.createHandler();
        handler2.setContributionURI(this.getClassURI(handlerClass));
        handler2.setContributorURI(contributorURI);
        handler2.setElementId(handlerClass.getName());
        handler2.setCommand(command);
        this.app.getHandlers().add(handler2);
    }

    private MCommand defineCommand(String categoryId, String commandId, String name, String description, String contributorURI) {
        MCommand command2;
        for (MCommand command2 : this.app.getCommands()) {
            if (!commandId.equals(command2.getElementId())) continue;
            return command2;
        }
        command2 = MCommandsFactory.INSTANCE.createCommand();
        command2.setCategory(this.defineCategory(categoryId));
        command2.setElementId(commandId);
        command2.setCommandName(name);
        command2.setDescription(description);
        command2.setContributorURI(contributorURI);
        this.app.getCommands().add(command2);
        return command2;
    }

    private MCategory defineCategory(String categoryId) {
        MCategory category2;
        for (MCategory category2 : this.app.getCategories()) {
            if (!categoryId.equals(category2.getElementId())) continue;
            return category2;
        }
        category2 = MCommandsFactory.INSTANCE.createCategory();
        category2.setElementId(categoryId);
        category2.setName(categoryId);
        this.app.getCategories().add(category2);
        return category2;
    }

    private String getClassURI(Class<?> clazz) {
        return String.valueOf(this.getBundleURI(clazz)) + "/" + clazz.getName();
    }

    private String getBundleURI(Class<?> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        if (bundle == null) {
            throw new IllegalArgumentException(clazz.getName());
        }
        return "bundleclass://" + bundle.getSymbolicName();
    }
}

