/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw;

import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.MetaDataExtension;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.AbstractMetaDataExtension;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWBufferPool;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionGroup;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Mask;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ModelPackage;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Permission;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EClass;

public class LUWMetaDataExtension
extends AbstractMetaDataExtension
implements MetaDataExtension {
    public int getMaximumIdentifierLength(SQLObject sqlObject) {
        int maximumIdentifierLength = 0;
        if (sqlObject instanceof LUWTableSpace) {
            LUWDatabase database;
            LUWTableSpace tablespace = (LUWTableSpace)sqlObject;
            LUWPartitionGroup group = tablespace.getGroup();
            if (group != null && (database = group.getDatabase()) != null) {
                DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition((Database)database);
                maximumIdentifierLength = dbDef.getTablespaceMaximumIdentifierLength();
            }
        } else if (sqlObject instanceof LUWIndex) {
            Database database;
            LUWIndex index = (LUWIndex)sqlObject;
            Schema schema = index.getSchema();
            if (schema != null && (database = ModelHelper.getDatabase((Schema)schema)) != null) {
                DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                String ver = dbDef.getVersion();
                if ("V8.1".equalsIgnoreCase(ver) || "V8.1".equalsIgnoreCase(ver)) {
                    maximumIdentifierLength = 18;
                } else if ("V9.1".equalsIgnoreCase(ver) || "V9.5".equalsIgnoreCase(ver)) {
                    maximumIdentifierLength = 128;
                }
            }
        } else if (sqlObject instanceof LUWBufferPool) {
            LUWBufferPool bufferPool = (LUWBufferPool)sqlObject;
            if (bufferPool != null) {
                maximumIdentifierLength = 18;
            }
        } else if (sqlObject instanceof DB2Permission || sqlObject instanceof DB2Mask) {
            maximumIdentifierLength = 128;
        }
        return maximumIdentifierLength;
    }

    public EClass getMetaClass(String metaClassName) {
        EClass eClass = (EClass)LUWPackage.eINSTANCE.getEClassifier(metaClassName);
        if (eClass == null) {
            eClass = (EClass)DB2ModelPackage.eINSTANCE.getEClassifier(metaClassName);
        }
        if (eClass == null) {
            if (metaClassName.equalsIgnoreCase("MaterializedQueryTable")) {
                eClass = (EClass)LUWPackage.eINSTANCE.getEClassifier("LUWMaterializedQueryTable");
            } else if (metaClassName.equalsIgnoreCase("Nickname")) {
                eClass = (EClass)LUWPackage.eINSTANCE.getEClassifier("LUWGenericNickname");
            } else if (metaClassName.equalsIgnoreCase("Tablespace")) {
                eClass = (EClass)LUWPackage.eINSTANCE.getEClassifier("LUWTableSpace");
            } else if (metaClassName.equalsIgnoreCase("Package")) {
                eClass = (EClass)LUWPackage.eINSTANCE.getEClassifier("LUWDatabasePackage");
            } else if (metaClassName.equalsIgnoreCase("Module")) {
                eClass = (EClass)LUWPackage.eINSTANCE.getEClassifier("LUWModule");
            } else if (metaClassName.equalsIgnoreCase("PLSQLPackage")) {
                eClass = (EClass)LUWPackage.eINSTANCE.getEClassifier("PLSQLPackage");
            } else if (metaClassName.equalsIgnoreCase("GlobalVariable")) {
                eClass = (EClass)LUWPackage.eINSTANCE.getEClassifier("LUWGlobalVariable");
            }
        }
        return eClass;
    }
}

