/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.papyrus.infra.widgets.databinding.CompletionStyledTextMultiReferenceDialogObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.CompletionStyledTextStringEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.util.ISetPapyrusConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CompletionStyledTextMultipleReferenceEditor
extends MultipleReferenceEditor
implements ISetPapyrusConverter {
    private CompletionStyledTextStringEditor editor;
    private IPapyrusConverter converter;

    public CompletionStyledTextMultipleReferenceEditor(Composite parent, int style, boolean ordered, boolean unique, String label) {
        super(parent, style, ordered, unique, label);
        this.addStyledTextSection(parent, style);
    }

    public CompletionStyledTextMultipleReferenceEditor(Composite parent, int style, String label) {
        super(parent, style, label);
        this.addStyledTextSection(parent, style);
    }

    public CompletionStyledTextMultipleReferenceEditor(Composite parent, int style) {
        super(parent, style);
        this.addStyledTextSection(parent, style);
    }

    protected void addStyledTextSection(Composite parent, int style) {
        this.editor = new CompletionStyledTextStringEditor((Composite)this, style | 0x800);
        GridData treeData = new GridData(4, 4, true, true);
        treeData.horizontalSpan = 2;
        this.editor.setLayoutData(treeData);
    }

    @Override
    public void setModelObservable(IObservableList modelProperty) {
        super.setModelObservable(modelProperty);
        CompletionStyledTextMultiReferenceDialogObservableValue styledTextObservable = new CompletionStyledTextMultiReferenceDialogObservableValue((Control)this.editor, this.editor.getText(), modelProperty, 16);
        styledTextObservable.setPapyrusConverter(this.converter);
        styledTextObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                CompletionStyledTextMultipleReferenceEditor.this.commit();
            }
        });
        this.editor.setValue(modelProperty);
    }

    @Override
    public void setPapyrusConverter(IPapyrusConverter converter) {
        this.converter = converter;
        this.editor.setPapyrusConverter(converter);
    }
}

