/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.adapter.EMFModelAdapter;
import org.eclipse.m2m.atl.engine.emfvm.adapter.IModelAdapter;

public class UML2ModelAdapter
extends EMFModelAdapter
implements IModelAdapter {
    private List<Invocation> delayedInvocations = new ArrayList<Invocation>();

    public void finalizeModel(IModel model) {
        super.finalizeModel(model);
        try {
            this.applyDelayedInvocations();
        }
        catch (InvocationTargetException e) {
            throw new VMException(null, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new VMException(null, e.getMessage(), e);
        }
    }

    public Object invoke(Method method, Object self, Object[] arguments) {
        if (method.getName().equals("applyProfile") || method.getName().equals("applyStereotype") || method.getName().equals("setValue") || method.getName().equals("applyAllRequiredStereotypes") || method.getName().equals("applyAllStereotypes") || method.getName().equals("unapplyAllStereotype") || method.getName().equals("unapplyAllNonApplicableStereotypes")) {
            this.addDelayedInvocation(new Invocation(method, self, method.getName().toString(), arguments));
            return null;
        }
        return super.invoke(method, self, arguments);
    }

    private void addDelayedInvocation(Invocation invocation) {
        if (invocation.opName.equals("applyProfile")) {
            this.delayedInvocations.add(0, invocation);
        } else if (invocation.opName.equals("applyStereotype") || invocation.opName.equals("applyAllStereotypes") || invocation.opName.equals("applyAllRequiredStereotypes")) {
            int lastApplyProfile = this.getLastStereotypeMethod("applyProfile");
            if (lastApplyProfile < this.delayedInvocations.size() - 1) {
                this.delayedInvocations.add(lastApplyProfile + 1, invocation);
            } else {
                this.delayedInvocations.add(invocation);
            }
        } else {
            this.delayedInvocations.add(invocation);
        }
    }

    private int getLastStereotypeMethod(String opName) {
        int rang = 0;
        int i = 0;
        while (i < this.delayedInvocations.size()) {
            Invocation invoc = this.delayedInvocations.get(rang);
            if (invoc.opName.equals(opName)) {
                rang = i;
            }
            ++i;
        }
        return rang;
    }

    private void applyDelayedInvocations() throws InvocationTargetException, IllegalAccessException {
        for (Invocation invocation : this.delayedInvocations) {
            invocation.method.invoke(invocation.self, invocation.arguments);
        }
        this.delayedInvocations.clear();
    }

    private final class Invocation {
        private final Method method;
        private final Object self;
        private final String opName;
        private final Object[] arguments;

        private Invocation(Method method, Object self, String opName, Object[] arguments) {
            this.method = method;
            this.self = self;
            this.opName = opName;
            this.arguments = arguments;
        }
    }
}

