/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Structure;

class StructureIterator
implements Iterator {
    protected final SimpleValueHandle valueHandle;
    protected final ArrayList<Structure> list;
    protected int index;

    public StructureIterator(SimpleValueHandle handle) {
        this.valueHandle = handle;
        this.list = this.valueHandle.getListValue();
        this.index = -1;
    }

    @Override
    public void remove() {
        if (this.index < 0 || this.index >= this.list.size()) {
            return;
        }
        try {
            this.valueHandle.removeItem(this.index);
            this.list.remove(this.index--);
        }
        catch (PropertyValueException propertyValueException) {}
    }

    @Override
    public boolean hasNext() {
        return this.list != null && this.index + 1 < this.list.size();
    }

    public Object next() {
        if (!this.hasNext()) {
            return null;
        }
        Structure struct = this.list.get(++this.index);
        return struct.getHandle(this.valueHandle, this.index);
    }
}

