/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class ShowInDebugAction
extends AbstractServerAction {
    public ShowInDebugAction(ISelectionProvider sp) {
        super(sp, "Console!");
        IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor desc = reg.find("org.eclipse.debug.ui.DebugView");
        this.setText(desc.getLabel());
        this.setImageDescriptor(desc.getImageDescriptor());
    }

    public boolean accept(IServer server) {
        return server.getServerType() != null && server.getServerState() != 4;
    }

    public void perform(IServer server) {
        block2: {
            try {
                ILaunch launch = server.getLaunch();
                this.selectProcess(launch.getProcesses()[0]);
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block2;
                Trace.trace("/severe", "Error showing in debug", e);
            }
        }
    }

    protected void selectProcess(IProcess process) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IDebugView view;
            IViewPart part;
            block6: {
                part = page.findView("org.eclipse.debug.ui.DebugView");
                if (part == null) {
                    try {
                        part = page.showView("org.eclipse.debug.ui.DebugView");
                    }
                    catch (PartInitException partInitException) {
                        if (!Trace.SEVERE) break block6;
                        Trace.trace("/severe", "Could not open debug view");
                    }
                }
            }
            if (part != null && (view = (IDebugView)part.getAdapter(IDebugView.class)) != null) {
                page.activate((IWorkbenchPart)part);
                view.setFocus();
                Viewer viewer = view.getViewer();
                if (viewer != null) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)process));
                }
            }
        }
    }
}

