/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.packet;

import java.nio.ByteBuffer;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.endpoint.ProtocolEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;

public abstract class Packet {
    protected static final String EMPTY_STRING = "";
    private final PcapFile fPcapFile;
    private final @Nullable Packet fParentPacket;
    private final PcapProtocol fProtocol;

    public Packet(PcapFile file, @Nullable Packet parent, PcapProtocol protocol) {
        this.fPcapFile = file;
        this.fParentPacket = parent;
        this.fProtocol = protocol;
    }

    public PcapFile getPcapFile() {
        return this.fPcapFile;
    }

    public @Nullable Packet getParentPacket() {
        return this.fParentPacket;
    }

    public abstract @Nullable Packet getChildPacket();

    public PcapProtocol getProtocol() {
        return this.fProtocol;
    }

    public abstract @Nullable ByteBuffer getPayload();

    public final @Nullable Packet getPacket(PcapProtocol protocol) {
        Packet wantedPacket = this;
        while (wantedPacket != null) {
            if (wantedPacket.getProtocol() == protocol) {
                return wantedPacket;
            }
            wantedPacket = wantedPacket.getParentPacket();
        }
        wantedPacket = this.getChildPacket();
        while (wantedPacket != null) {
            if (wantedPacket.getProtocol() == protocol) {
                return wantedPacket;
            }
            wantedPacket = wantedPacket.getChildPacket();
        }
        return null;
    }

    public final boolean hasProtocol(PcapProtocol protocol) {
        Packet wantedPacket = this;
        while (wantedPacket != null) {
            if (wantedPacket.getProtocol() == protocol) {
                return true;
            }
            wantedPacket = wantedPacket.getParentPacket();
        }
        wantedPacket = this.getChildPacket();
        while (wantedPacket != null) {
            if (wantedPacket.getProtocol() == protocol) {
                return true;
            }
            wantedPacket = wantedPacket.getChildPacket();
        }
        return false;
    }

    public Packet getMostEcapsulatedPacket() {
        @NonNull Packet packet = this;
        while (packet.getProtocol() != PcapProtocol.UNKNOWN) {
            Packet childPacket = packet.getChildPacket();
            if (childPacket == null || childPacket.getProtocol() == PcapProtocol.UNKNOWN) break;
            packet = childPacket;
        }
        return packet;
    }

    public abstract boolean validate();

    protected abstract @Nullable Packet findChildPacket() throws BadPacketException;

    public abstract ProtocolEndpoint getSourceEndpoint();

    public abstract ProtocolEndpoint getDestinationEndpoint();

    public abstract Map<String, String> getFields();

    public abstract String getLocalSummaryString();

    protected abstract String getSignificationString();

    public final String getGlobalSummaryString() {
        Packet packet = this.getMostEcapsulatedPacket();
        return packet.getSignificationString();
    }

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    protected static final boolean isBitSet(byte value, int bit) {
        if (bit < 0 || bit > 7) {
            throw new IllegalArgumentException("The byte index is not valid!");
        }
        return (value >>> bit & 1) == 1;
    }
}

