/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class WidgetHandler {
    private static final Logger log = Logger.getLogger(WidgetHandler.class);
    private static WidgetHandler instance;

    public static WidgetHandler getInstance() {
        if (instance == null) {
            instance = new WidgetHandler();
        }
        return instance;
    }

    public boolean isDisposed(final Widget widget) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return widget.isDisposed();
            }
        });
    }

    public int getStyle(final Widget w) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return w.getStyle();
            }
        });
    }

    public void sendClickNotifications(Widget widget) {
        this.notifyWidget(13, widget);
    }

    public void notifyWidget(int eventType, Widget widget) {
        Event event = this.createEvent(widget);
        this.notifyWidget(eventType, event, widget);
    }

    public void notifyItem(int eventType, int detail, Widget widget, Widget widgetItem) {
        Event event = this.createEventItem(eventType, detail, widget, widgetItem);
        this.notifyWidget(eventType, event, widget);
    }

    public void notifyItemMouse(int eventType, int detail, Widget widget, Widget widgetItem, int x, int y, int button) {
        Event event = this.createMouseItemEvent(eventType, detail, widget, widgetItem, x, y, button);
        this.notifyWidget(eventType, event, widget);
    }

    public void notifyWidget(final int eventType, final Event createEvent, final Widget widget) {
        createEvent.type = eventType;
        log.trace("Notify " + widget.getClass().getSimpleName() + " with event " + eventType);
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (widget == null || widget.isDisposed()) {
                    return;
                }
                widget.notifyListeners(eventType, createEvent);
            }
        });
        log.trace("Wait for synchronization");
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private Event createEvent(Widget widget) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = widget;
        event.display = Display.getDisplay();
        return event;
    }

    private Event createEventItem(int eventType, int detail, Widget widget, Widget widgetItem) {
        Event event = new Event();
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.item = widgetItem;
        event.widget = widget;
        event.detail = detail;
        event.type = eventType;
        return event;
    }

    private Event createMouseItemEvent(int eventType, int detail, Widget widget, Widget widgetItem, int x, int y, int button) {
        Event event = new Event();
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.item = widgetItem;
        event.widget = widget;
        event.detail = detail;
        event.type = eventType;
        event.button = button;
        event.x = x;
        event.y = y;
        if (eventType == 8) {
            event.count = 2;
        }
        return event;
    }

    public Object getData(final Widget swtWidget) {
        log.debug("Get widget data");
        return Display.syncExec((ResultRunnable)new ResultRunnable<Object>(){

            public Object run() {
                return swtWidget.getData();
            }
        });
    }

    public Object getData(final Widget swtWidget, final String key) {
        log.debug("Get widget data with key " + key);
        return Display.syncExec((ResultRunnable)new ResultRunnable<Object>(){

            public Object run() {
                return swtWidget.getData(key);
            }
        });
    }
}

