/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.qvttrace.util;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.runtime.qvttrace.Dispatch;
import org.eclipse.qvtd.runtime.qvttrace.Execution;
import org.eclipse.qvtd.runtime.qvttrace.TraceElement;
import org.eclipse.qvtd.runtime.qvttrace.TraceInstance;
import org.eclipse.qvtd.runtime.qvttrace.TraceModel;
import org.eclipse.qvtd.runtime.qvttrace.util.AbstractQVTtraceVisitor;
import org.eclipse.qvtd.runtime.qvttrace.util.QVTtraceVisitor;
import org.eclipse.qvtd.runtime.qvttrace.util.TraceVisitable;

public abstract class AbstractWrappingQVTtraceVisitor<R, C, @NonNull D extends QVTtraceVisitor<R>, P>
extends AbstractQVTtraceVisitor<R, C>
implements QVTtraceVisitor<R> {
    protected final @NonNull D delegate;

    protected AbstractWrappingQVTtraceVisitor(@NonNull D delegate, C context) {
        super(context);
        this.delegate = delegate;
    }

    protected R badVisit(@NonNull TraceVisitable visitable, @Nullable P prologue, @NonNull Throwable e) throws RuntimeException {
        if (e instanceof Exception) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    protected @NonNull D getDelegate() {
        return this.delegate;
    }

    protected R postVisit(@NonNull TraceVisitable visitable, @Nullable P prologue, R result) {
        return result;
    }

    protected @Nullable P preVisit(@NonNull TraceVisitable visitable) {
        return null;
    }

    @Override
    public R visiting(@NonNull TraceVisitable visitable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public R visitDispatch(@NonNull Dispatch object) {
        @Nullable P prologue = this.preVisit(object);
        try {
            Object result = this.delegate.visitDispatch(object);
            return this.postVisit(object, prologue, result);
        }
        catch (Throwable e) {
            return this.badVisit(object, prologue, e);
        }
    }

    @Override
    public R visitExecution(@NonNull Execution object) {
        @Nullable P prologue = this.preVisit(object);
        try {
            Object result = this.delegate.visitExecution(object);
            return this.postVisit(object, prologue, result);
        }
        catch (Throwable e) {
            return this.badVisit(object, prologue, e);
        }
    }

    @Override
    public R visitTraceElement(@NonNull TraceElement object) {
        @Nullable P prologue = this.preVisit(object);
        try {
            Object result = this.delegate.visitTraceElement(object);
            return this.postVisit(object, prologue, result);
        }
        catch (Throwable e) {
            return this.badVisit(object, prologue, e);
        }
    }

    @Override
    public R visitTraceInstance(@NonNull TraceInstance object) {
        @Nullable P prologue = this.preVisit(object);
        try {
            Object result = this.delegate.visitTraceInstance(object);
            return this.postVisit(object, prologue, result);
        }
        catch (Throwable e) {
            return this.badVisit(object, prologue, e);
        }
    }

    @Override
    public R visitTraceModel(@NonNull TraceModel object) {
        @Nullable P prologue = this.preVisit(object);
        try {
            Object result = this.delegate.visitTraceModel(object);
            return this.postVisit(object, prologue, result);
        }
        catch (Throwable e) {
            return this.badVisit(object, prologue, e);
        }
    }
}

