/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring.infrastructure;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.refactoring.IEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Messages;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public abstract class FortranEditorRefactoring
extends FortranResourceRefactoring
implements IEditorRefactoring {
    protected IFile fileInEditor;
    protected ITextSelection selectedRegionInEditor;
    protected IFortranAST astOfFileInEditor;

    @Override
    public final void initialize(List<IFile> files) {
        throw new IllegalArgumentException("#initialize(List) cannot be invoked on VPGEditorRefactoring");
    }

    @Override
    public void initialize(IFile file, ITextSelection selection) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cannot be null");
        }
        super.initialize(Collections.singletonList(file));
        this.fileInEditor = file;
        this.selectedRegionInEditor = selection;
        this.astOfFileInEditor = null;
    }

    public void initialize(IFile file) {
        this.initialize(file, null);
    }

    @Override
    protected void checkFiles(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        assert (this.fileInEditor != null);
        this.checkIfFileIsAccessibleAndWritable(this.fileInEditor);
        this.astOfFileInEditor = (IFortranAST)((PhotranVPG)this.vpg).acquireTransientAST(this.fileInEditor);
        this.logVPGErrors(status, this.fileInEditor);
        if (this.astOfFileInEditor == null) {
            this.fail(Messages.FortranEditorRefactoring_FileInEditorCannotBeParsed);
        }
    }

    @Override
    protected void ensureProjectHasRefactoringEnabled(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        if (!PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(this.fileInEditor)) {
            this.fail(Messages.FortranEditorRefactoring_AnalysisRefactoringNotEnabled);
        }
    }

    @Override
    protected void postCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
        this.astOfFileInEditor = null;
    }

    @Override
    protected void preCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        if (this.astOfFileInEditor == null) {
            this.checkInitialConditions(pm, true);
        }
    }
}

