/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTNodePair;
import org.eclipse.photran.internal.core.parser.ASTNodeUtil;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IASTVisitor;

public class ASTSeparatedListNode<T extends IASTNode>
extends AbstractList<T>
implements IASTListNode<T> {
    private IASTNode parent = null;
    private ArrayList<Token> separators = new ArrayList();
    private ArrayList<T> entries = new ArrayList();

    public ASTSeparatedListNode() {
    }

    public ASTSeparatedListNode(Token separator, List<T> entries) {
        this(separator, entries, false);
    }

    public ASTSeparatedListNode(Token separator, List<T> entries, boolean trimWhiteText) {
        boolean first = true;
        for (IASTNode entry : entries) {
            if (trimWhiteText && entry != null && entry instanceof Token) {
                Token tok = (Token)((Token)entry).clone();
                tok.setWhiteBefore("");
                tok.setWhiteAfter("");
                entry = tok;
            }
            if (first) {
                this.add(null, entry);
                first = false;
                continue;
            }
            this.add(separator, entry);
        }
    }

    public void add(Token separator, T entry) {
        this.separators.add(separator);
        this.entries.add(entry);
        if (separator != null) {
            separator.setParent(this);
        }
        if (entry != null) {
            entry.setParent(this);
        }
    }

    @Override
    public T remove(int index) {
        Token separator = this.separators.remove(index);
        IASTNode result = (IASTNode)this.entries.remove(index);
        if (index == 0 && separator == null && !this.separators.isEmpty()) {
            this.separators.set(0, null);
        }
        return (T)result;
    }

    public ASTNodePair<Token, T> getPair(int index) {
        return new ASTNodePair<Token, IASTNode>(this.separators.get(index), (IASTNode)this.entries.get(index));
    }

    @Override
    public void insertBefore(T insertBefore, T newElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertAfter(T insertAfter, T newElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        return (T)((IASTNode)this.entries.get(index));
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public IASTNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IASTNode parent) {
        this.parent = parent;
    }

    @Override
    public Iterable<? extends IASTNode> getChildren() {
        return new Iterable<IASTNode>(){

            @Override
            public Iterator<IASTNode> iterator() {
                return new ASTNodeUtil.NonNullIterator<IASTNode>(new Iterator<IASTNode>(){
                    private int index;
                    private int count;
                    {
                        this.index = !ASTSeparatedListNode.this.separators.isEmpty() && ASTSeparatedListNode.this.separators.get(0) == null ? 1 : 0;
                        this.count = ASTSeparatedListNode.this.entries.size() * 2;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.count;
                    }

                    @Override
                    public IASTNode next() {
                        if (this.index % 2 == 0) {
                            return (IASTNode)ASTSeparatedListNode.this.separators.get(this.index++ / 2);
                        }
                        return (IASTNode)ASTSeparatedListNode.this.entries.get(this.index++ / 2);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visitASTNode(this);
        visitor.visitASTListNode(this);
    }

    @Override
    public <T extends IASTNode> Set<T> findAll(Class<T> targetClass) {
        return ASTNodeUtil.findAll(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findNearestAncestor(Class<T> targetClass) {
        return ASTNodeUtil.findNearestAncestor(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findFirst(Class<T> targetClass) {
        return ASTNodeUtil.findFirst(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findLast(Class<T> targetClass) {
        return ASTNodeUtil.findLast(this, targetClass);
    }

    @Override
    public Token findFirstToken() {
        return ASTNodeUtil.findFirstToken(this);
    }

    @Override
    public Token findLastToken() {
        return ASTNodeUtil.findLastToken(this);
    }

    @Override
    public boolean isFirstChildInList() {
        return ASTNodeUtil.isFirstChildInList(this);
    }

    @Override
    public IPreprocessorReplacement printOn(PrintStream out, IPreprocessorReplacement currentPreprocessorDirective) {
        return ASTNodeUtil.print(this, currentPreprocessorDirective, out);
    }

    @Override
    public String toString() {
        return ASTNodeUtil.toString(this);
    }

    @Override
    public void replaceChild(IASTNode node, IASTNode withNode) {
        int i = this.entries.indexOf(node);
        if (i >= 0) {
            this.entries.set(i, withNode);
            if (withNode != null) {
                withNode.setParent(this);
            }
            return;
        }
        i = this.separators.indexOf(node);
        if (i >= 0) {
            this.separators.set(i, (Token)withNode);
            if (withNode != null) {
                withNode.setParent(this);
            }
            return;
        }
        throw new IllegalStateException("Child node not found");
    }

    @Override
    public void removeFromTree() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceWith(IASTNode newNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceWith(String literalString) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        IASTNode newChild;
        ASTSeparatedListNode<T> copy = new ASTSeparatedListNode<T>();
        for (Token token : this.separators) {
            if (token == null) {
                copy.separators.add(null);
                continue;
            }
            newChild = (Token)token.clone();
            ((Token)newChild).setParent(copy);
            copy.separators.add((Token)newChild);
        }
        for (IASTNode iASTNode : this.entries) {
            if (iASTNode == null) {
                copy.entries.add(null);
                continue;
            }
            newChild = (IASTNode)iASTNode.clone();
            newChild.setParent(copy);
            copy.entries.add(newChild);
        }
        return copy;
    }
}

