/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;

public class IncludeLoaderCallback {
    protected IProject project;

    public IncludeLoaderCallback(IProject project) {
        this.project = project;
    }

    public Reader getIncludedFileAsStream(String fileToInclude) throws FileNotFoundException {
        try {
            IFile file = this.getIncludedFile(fileToInclude);
            try {
                return new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset()));
            }
            catch (UnsupportedEncodingException e) {
                return new BufferedReader(new InputStreamReader(file.getContents(true)));
            }
        }
        catch (CoreException e) {
            throw new FileNotFoundException(String.valueOf(fileToInclude) + " - " + e.getMessage());
        }
    }

    protected IFile getIncludedFile(String fileToInclude) throws FileNotFoundException {
        String[] paths = new SearchPathProperties().getListProperty(this.project, "FortranIncludePaths");
        int i = 0;
        while (i < paths.length) {
            IFile result;
            IResource folder = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
            if (folder != null && folder.isAccessible() && (result = this.getIncludedFile(fileToInclude, folder)) != null) {
                return result;
            }
            ++i;
        }
        throw new FileNotFoundException(fileToInclude);
    }

    private IFile getIncludedFile(String fileToInclude, IResource folder) {
        class Visitor
        implements IResourceVisitor {
            private IFile result = null;
            private final /* synthetic */ String val$fileToInclude;

            Visitor(String string) {
                this.val$fileToInclude = string;
            }

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && resource.isAccessible() && resource.getName().equals(this.val$fileToInclude)) {
                    this.result = (IFile)resource;
                    return false;
                }
                return true;
            }
        }
        Visitor visitor = new Visitor(fileToInclude);
        try {
            ((IContainer)folder).accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            throw new Error(e);
        }
        return visitor.result;
    }

    public void logError(String message, IFile topLevelFile, int offset) {
    }
}

