/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.flow;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.photran.internal.core.analysis.flow.FlowGraph;
import org.eclipse.photran.internal.core.analysis.flow.FlowGraphNode;
import org.eclipse.photran.internal.core.util.Worklist;
import org.eclipse.photran.internal.core.vpg.IVPGNode;
import org.eclipse.photran.internal.core.vpg.VPG;

public abstract class VPGFlowGraph<R extends IVPGNode<T>, T, U>
extends FlowGraph<U> {
    private final NodeFactory nodeFactory;
    protected final VPG<?, ?, R> vpg;

    public VPGFlowGraph(VPG<?, ?, R> vpg, R entryNodeRef, R exitNodeRef, int controlFlowEdgeType) {
        this.vpg = vpg;
        this.nodeFactory = new NodeFactory();
        this.entryNode = this.nodeFactory.nodeFor(entryNodeRef);
        this.exitNode = this.nodeFactory.nodeFor(exitNodeRef);
        this.populate(entryNodeRef, exitNodeRef, controlFlowEdgeType);
    }

    public VPGFlowGraph(VPG<?, ?, R> vpg, R entryNodeRef, R exitNodeRef, Enum<?> controlFlowEdgeType) {
        this(vpg, entryNodeRef, exitNodeRef, controlFlowEdgeType.ordinal());
    }

    private void populate(R entryNodeRef, R exitNodeRef, int controlFlowEdgeType) {
        Worklist<R> worklist = new Worklist<R>(entryNodeRef);
        for (IVPGNode currentNodeRef : worklist) {
            FlowGraphNode currentNode = this.nodeFactory.get(currentNodeRef);
            for (IVPGNode successorNodeRef : currentNodeRef.followOutgoing(controlFlowEdgeType)) {
                if (this.nodeFactory.containsKey(successorNodeRef)) {
                    currentNode.connectTo(this.nodeFactory.get(successorNodeRef));
                    continue;
                }
                FlowGraphNode successorNode = this.nodeFactory.nodeFor(successorNodeRef);
                currentNode.connectTo(successorNode);
                worklist.add(successorNodeRef);
            }
        }
    }

    protected abstract U map(R var1);

    private final class NodeFactory {
        private final Map<R, FlowGraphNode<U>> nodes = new HashMap();
        private int lastNodeNumber = 0;

        private NodeFactory() {
        }

        public FlowGraphNode<U> nodeFor(R tokenRef) {
            if (this.nodes.containsKey(tokenRef)) {
                return this.nodes.get(tokenRef);
            }
            FlowGraphNode result = new FlowGraphNode(this.generateNodeName(), VPGFlowGraph.this.map(tokenRef));
            this.nodes.put(tokenRef, result);
            return result;
        }

        private String generateNodeName() {
            return "node" + Integer.toString(++this.lastNodeNumber);
        }

        public FlowGraphNode<U> get(R tokenRef) {
            return this.nodes.get(tokenRef);
        }

        public boolean containsKey(R tokenRef) {
            return this.nodes.containsKey(tokenRef);
        }
    }
}

