/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.mylyn.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.mylyn.exceptions.InvalidALMAttributeException;
import org.eclipse.jubula.mylyn.i18n.Messages;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MylynAccess {
    private static final Logger LOG = LoggerFactory.getLogger(MylynAccess.class);

    private MylynAccess() {
    }

    public static TaskRepository getRepositoryByLabel(String repoLabel) {
        List<TaskRepository> allRepositories = MylynAccess.getAllRepositories();
        for (TaskRepository repo : allRepositories) {
            if (!repo.getRepositoryLabel().equals(repoLabel)) continue;
            return repo;
        }
        return null;
    }

    public static List<TaskRepository> getAllRepositories() {
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        return repositoryManager.getAllRepositories();
    }

    public static ITask getTaskByID(TaskRepository repo, String taskId, IProgressMonitor monitor) throws CoreException {
        IRepositoryModel repositoryModel;
        ITask task = null;
        if (MylynAccess.validRepository(repo) && (task = (repositoryModel = TasksUi.getRepositoryModel()).getTask(repo, taskId)) == null) {
            task = repositoryModel.createTask(repo, taskId);
        }
        return task;
    }

    private static boolean validRepository(TaskRepository repo) {
        return repo != null && !repo.isOffline();
    }

    public static TaskData getTaskDataByID(TaskRepository repo, String taskId, IProgressMonitor monitor) throws CoreException {
        TaskData taskData = null;
        if (MylynAccess.validRepository(repo)) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repo.getConnectorKind());
            if (connector.getConnectorKind().toLowerCase().contains(CONNECTOR.TASKTOP.name().toLowerCase())) {
                TaskData partialTaskData;
                if (connector.supportsSearchByTaskKey(repo) && (partialTaskData = connector.searchByTaskKey(repo, taskId, monitor)) != null) {
                    taskData = connector.getTaskData(repo, partialTaskData.getTaskId(), monitor);
                }
            } else {
                taskData = connector.getTaskData(repo, taskId, monitor);
            }
        }
        return taskData;
    }

    public static IStatus testConnection(String repoLabel) {
        TaskRepository repository = MylynAccess.getRepositoryByLabel(repoLabel);
        if (repository == null) {
            return new Status(4, "org.eclipse.jubula.mylyn", NLS.bind((String)Messages.TaskRepositoryNotFound, (Object)repoLabel));
        }
        if (repository.isOffline()) {
            return new Status(4, "org.eclipse.jubula.mylyn", NLS.bind((String)Messages.TaskRepositoryOffline, (Object)repoLabel));
        }
        boolean savePassword = repository.getSavePassword(AuthenticationType.REPOSITORY);
        if (!savePassword) {
            return new Status(4, "org.eclipse.jubula.mylyn", NLS.bind((String)Messages.TaskRepositoryNoCredentialsStored, (Object)repoLabel));
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repository.getConnectorKind());
        if (connector == null) {
            return new Status(4, "org.eclipse.jubula.mylyn", NLS.bind((String)Messages.TaskRepositoryNoConnectorFound, (Object)repoLabel));
        }
        try {
            connector.updateRepositoryConfiguration(repository, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.jubula.mylyn", e.getLocalizedMessage().replace("\n\n", " "));
        }
        IStatus repoStatus = repository.getStatus();
        if (repoStatus != null) {
            return repoStatus;
        }
        return Status.OK_STATUS;
    }

    public static IStatus updateAttributes(TaskRepository repo, String taskId, List<Map<String, String>> attributeUpdates, IProgressMonitor monitor) {
        MultiStatus updateInfo;
        block10: {
            updateInfo = new MultiStatus("org.eclipse.jubula.mylyn", 1, "Task update is about to start...", null);
            try {
                TaskData taskData = MylynAccess.getTaskDataByID(repo, taskId, monitor);
                if (taskData != null) {
                    ITask task = MylynAccess.getTaskByID(repo, taskData.getTaskId(), monitor);
                    if (task == null) break block10;
                    String connectorKind = repo.getConnectorKind();
                    AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)connectorKind);
                    AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
                    ITaskDataManager taskDataManager = TasksUi.getTaskDataManager();
                    ITaskDataWorkingCopy taskWorkingCopy = taskDataManager.createWorkingCopy(task, taskData);
                    TaskDataModel taskModel = new TaskDataModel(repo, task, taskWorkingCopy);
                    TaskAttribute rootData = taskModel.getTaskData().getRoot();
                    for (Map<String, String> udpate : attributeUpdates) {
                        List<TaskAttribute> changes = MylynAccess.attributeUpdateHandling(udpate, rootData);
                        if (changes.isEmpty()) {
                            updateInfo.add((IStatus)new Status(1, "org.eclipse.jubula.mylyn", "No changes for Task."));
                            continue;
                        }
                        for (TaskAttribute change : changes) {
                            taskModel.attributeChanged(change);
                        }
                        RepositoryResponse response = taskDataHandler.postTaskData(taskModel.getTaskRepository(), taskModel.getTaskData(), taskModel.getChangedOldAttributes(), monitor);
                        if (response != null && RepositoryResponse.ResponseKind.TASK_UPDATED.equals((Object)response.getReposonseKind())) {
                            updateInfo.add((IStatus)new Status(0, "org.eclipse.jubula.mylyn", "Task has been updated."));
                        } else {
                            updateInfo.add((IStatus)new Status(2, "org.eclipse.jubula.mylyn", "Task might not have been updated successfully."));
                        }
                        if (monitor == null || !monitor.isCanceled()) continue;
                        updateInfo.add((IStatus)new Status(0, "org.eclipse.jubula.mylyn", "Task update has been cancelled."));
                        break block10;
                    }
                    break block10;
                }
                updateInfo.add((IStatus)new Status(4, "org.eclipse.jubula.mylyn", "No task data found in the given repository!"));
            }
            catch (InvalidALMAttributeException e) {
                updateInfo.add((IStatus)new Status(4, "org.eclipse.jubula.mylyn", e.getMessage()));
            }
            catch (CoreException e) {
                updateInfo.add((IStatus)new Status(4, "org.eclipse.jubula.mylyn", e.getLocalizedMessage()));
            }
            catch (IllegalArgumentException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                updateInfo.add((IStatus)new Status(4, "org.eclipse.jubula.mylyn", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return updateInfo;
    }

    private static List<TaskAttribute> attributeUpdateHandling(Map<String, String> attributesToChange, TaskAttribute rootAttr) throws InvalidALMAttributeException {
        ArrayList<TaskAttribute> changes = new ArrayList<TaskAttribute>();
        for (String key : attributesToChange.keySet()) {
            if (StringUtils.isBlank((String)key)) {
                throw new InvalidALMAttributeException(Messages.BlankAttributeID);
            }
            TaskAttribute attributeUpdate = rootAttr.getAttribute(key);
            if (attributeUpdate == null) {
                throw new InvalidALMAttributeException(NLS.bind((String)Messages.InvalidAttributeID, (Object)key));
            }
            if (attributeUpdate.getMetaData().isReadOnly()) {
                throw new InvalidALMAttributeException(NLS.bind((String)Messages.ReadOnlyAttributeID, (Object)key));
            }
            String value = attributesToChange.get(key);
            Map options = attributeUpdate.getOptions();
            if (options != null && !options.isEmpty() && !options.containsKey(value)) {
                throw new InvalidALMAttributeException(NLS.bind((String)Messages.InvalidValue, (Object)value, (Object)key));
            }
            attributeUpdate.setValue(value);
            changes.add(attributeUpdate);
        }
        return changes;
    }

    public static enum CONNECTOR {
        DEFAULT,
        HP_ALM,
        TASKTOP;

    }
}

