/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;

public class JSPPathIndexer {
    static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public IPath[] getVisibleJspPaths(SearchPattern pattern, IJavaSearchScope scope) {
        JSPFileVisitor jspFileVisitor = new JSPFileVisitor(pattern, scope);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)jspFileVisitor, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return jspFileVisitor.getPaths();
    }

    class JSPFileVisitor
    implements IResourceProxyVisitor {
        private Set<IPath> fPaths = new HashSet<IPath>();
        IJavaSearchScope fScope = null;
        SearchPattern fPattern = null;

        public JSPFileVisitor(SearchPattern pattern, IJavaSearchScope scope) {
            this.fPattern = pattern;
            this.fScope = scope;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (JSPSearchSupport.getInstance().isCanceled() || proxy.isDerived()) {
                return false;
            }
            if (proxy.getType() == 1) {
                IPath fullPath;
                if (ContentTypeIdForJSP.indexOfJSPExtension(proxy.getName()) >= 0 && this.fScope.encloses((fullPath = proxy.requestFullPath()).toString())) {
                    if (DEBUG) {
                        System.out.println("adding selected index path:" + fullPath.removeLastSegments(1));
                    }
                    this.fPaths.add(JSPSearchSupport.getInstance().computeIndexLocation(fullPath.removeLastSegments(1)));
                }
                return false;
            }
            return true;
        }

        public IPath[] getPaths() {
            return this.fPaths.toArray(new IPath[this.fPaths.size()]);
        }
    }
}

