/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import org.eclipse.jpt.common.ui.internal.swt.events.DisposeAdapter;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

abstract class BooleanControlStateModelBinding<C extends Control> {
    private final PropertyValueModel<Boolean> booleanModel;
    private final PropertyChangeListener booleanListener;
    boolean booleanValue;
    private final boolean defaultValue;
    private final Adapter<C> adapter;
    private final DisposeListener controlDisposeListener;

    BooleanControlStateModelBinding(PropertyValueModel<Boolean> booleanModel, boolean defaultValue, Adapter<C> adapter) {
        if (booleanModel == null || adapter == null) {
            throw new NullPointerException();
        }
        this.booleanModel = booleanModel;
        this.defaultValue = defaultValue;
        this.booleanValue = this.booleanValue(null);
        this.adapter = adapter;
        this.booleanListener = this.buildBooleanListener();
        this.controlDisposeListener = this.buildControlDisposeListener();
    }

    private PropertyChangeListener buildBooleanListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)new BooleanListener());
    }

    private DisposeListener buildControlDisposeListener() {
        return new ControlDisposeListener();
    }

    void engageBooleanModel() {
        this.booleanModel.addPropertyChangeListener("value", this.booleanListener);
        this.booleanValue = this.booleanValue((Boolean)this.booleanModel.getValue());
    }

    void disengageBooleanModel() {
        this.booleanModel.removePropertyChangeListener("value", this.booleanListener);
        this.booleanValue = this.booleanValue(null);
    }

    void booleanChanged(PropertyChangeEvent event) {
        if (!this.controlIsDisposed()) {
            this.booleanChanged((Boolean)event.getNewValue());
        }
    }

    private void booleanChanged(Boolean b) {
        this.booleanValue = this.booleanValue(b);
        this.setControlState();
    }

    private boolean booleanValue(Boolean b) {
        return b != null ? b : this.defaultValue;
    }

    void engageControl(C control) {
        control.addDisposeListener(this.controlDisposeListener);
    }

    void disengageControl(C control) {
        control.removeDisposeListener(this.controlDisposeListener);
    }

    abstract void setControlState();

    void setControlState(C control) {
        if (!control.isDisposed()) {
            this.adapter.setState(control, this.booleanValue);
        }
    }

    void controlDisposed(C control) {
        this.disengageControl(control);
    }

    abstract boolean controlIsDisposed();

    public String toString() {
        return ObjectTools.toString((Object)this, this.booleanModel);
    }

    static interface Adapter<C extends Control> {
        public void setState(C var1, boolean var2);
    }

    class BooleanListener
    extends PropertyChangeAdapter {
        BooleanListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            BooleanControlStateModelBinding.this.booleanChanged(event);
        }
    }

    class ControlDisposeListener
    extends DisposeAdapter {
        ControlDisposeListener() {
        }

        @Override
        public void widgetDisposed(DisposeEvent event) {
            Control control = (Control)event.widget;
            BooleanControlStateModelBinding.this.controlDisposed(control);
        }
    }
}

