/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.common.ui.internal.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.facet.common.ui.internal.Activator;
import org.eclipse.emf.facet.common.ui.internal.Messages;
import org.eclipse.emf.facet.common.ui.internal.controls.PersistableColumn;
import org.eclipse.emf.facet.common.ui.internal.exported.views.IColumnDescription;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementsView
extends ViewPart {
    private static final int JOB_SCHEDULE_DELAY = 500;
    private final Collection<? extends IColumnDescription> columnDescriptions;
    private final ITreeContentProvider contentProvider;
    private final Object input;
    private final List<PersistableColumn> columns = new ArrayList<PersistableColumn>();
    private final Map<String, Integer> persistedValues = new HashMap<String, Integer>();
    private TreeViewer treeViewer;
    private Job refreshJob = null;
    private final IOpenListener openListener;
    private final String title;
    private final Image titleImage;

    public ElementsView(Collection<? extends IColumnDescription> columnDescriptions, ITreeContentProvider contentProvider, Object input, String title, Image titleImage, IOpenListener openListener) {
        this.columnDescriptions = columnDescriptions;
        this.contentProvider = contentProvider;
        this.input = input;
        this.title = title;
        this.titleImage = titleImage;
        this.openListener = openListener;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void createPartControl(Composite parent) {
        this.setPartName(this.title);
        this.setTitleImage(this.titleImage);
        parent.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(parent, 66308);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ElementsView.this.open(event);
            }
        });
        this.createColumns();
        this.treeViewer.setContentProvider(this.getContentProvider());
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.refresh(false);
    }

    protected void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = contextMenu.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.getViewer());
    }

    protected void createColumns() {
        for (IColumnDescription iColumnDescription : this.columnDescriptions) {
            this.createColumn(iColumnDescription.getTitle(), iColumnDescription.getUniqueID(), iColumnDescription.getDefaultWidth(), iColumnDescription.getColumnLabelProvider());
        }
    }

    protected IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected void open(OpenEvent event) {
        if (this.openListener != null) {
            this.openListener.open(event);
        }
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected void refresh(boolean delayed) {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(this.getRefreshMessage()){

                protected IStatus run(IProgressMonitor monitor) {
                    ElementsView.this.doRefresh();
                    return Status.OK_STATUS;
                }
            };
        }
        this.refreshJob.cancel();
        if (delayed) {
            this.refreshJob.setPriority(50);
            this.refreshJob.schedule(500L);
        } else {
            this.refreshJob.setPriority(10);
            this.refreshJob.schedule();
        }
    }

    protected String getRefreshMessage() {
        return NLS.bind((String)Messages.ElementsView_refreshJobTitle, (Object)this.title);
    }

    protected Object getInput() {
        return this.input;
    }

    protected void doRefresh() {
        final Object viewerInput = this.getInput();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ElementsView.this.getViewer().setInput(viewerInput);
                ElementsView.this.getViewer().refresh();
            }
        });
    }

    protected void createColumn(String columnText, String uniqueID, int defaultWidth, ColumnLabelProvider columnLabelProvider) {
        PersistableColumn persistableColumn = new PersistableColumn(columnText, uniqueID, defaultWidth, columnLabelProvider, this.treeViewer);
        this.columns.add(persistableColumn);
        Integer width = this.persistedValues.get(uniqueID);
        if (width != null) {
            persistableColumn.setWidth(width);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        try {
            for (PersistableColumn column : this.columns) {
                column.saveState(memento);
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)"Error saving view state", (Plugin)Activator.getDefault());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            String[] attributeKeys;
            String[] stringArray = attributeKeys = memento.getAttributeKeys();
            int n = attributeKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.persistedValues.put(key, memento.getInteger(key));
                ++n2;
            }
        }
    }
}

