/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.function;

import org.eclipse.collections.api.block.function.Function2;

public final class MinFunction {
    public static final Function2<Integer, Integer, Integer> INTEGER = new MinIntegerFunction();
    public static final Function2<Double, Double, Double> DOUBLE = new MinDoubleFunction();
    public static final Function2<Long, Long, Long> LONG = new MinLongFunction();

    private MinFunction() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    private static class MinDoubleFunction
    implements Function2<Double, Double, Double> {
        private static final long serialVersionUID = 1L;

        private MinDoubleFunction() {
        }

        @Override
        public Double value(Double argument1, Double argument2) {
            if (argument1 == null) {
                return argument2;
            }
            if (argument2 == null) {
                return argument1;
            }
            return argument1 < argument2 ? argument1 : argument2;
        }
    }

    private static class MinIntegerFunction
    implements Function2<Integer, Integer, Integer> {
        private static final long serialVersionUID = 1L;

        private MinIntegerFunction() {
        }

        @Override
        public Integer value(Integer argument1, Integer argument2) {
            if (argument1 == null) {
                return argument2;
            }
            if (argument2 == null) {
                return argument1;
            }
            return argument1 < argument2 ? argument1 : argument2;
        }
    }

    private static class MinLongFunction
    implements Function2<Long, Long, Long> {
        private static final long serialVersionUID = 1L;

        private MinLongFunction() {
        }

        @Override
        public Long value(Long argument1, Long argument2) {
            if (argument1 == null) {
                return argument2;
            }
            if (argument2 == null) {
                return argument1;
            }
            return argument1 < argument2 ? argument1 : argument2;
        }
    }
}

