/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher.ui.launchbar;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager2;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.cdt.internal.docker.launcher.ui.launchbar.ContainerGCCToolChain;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerImage;

public class ContainerGCCToolChainProvider
implements IToolChainProvider,
IDockerConnectionManagerListener {
    public static final String PROVIDER_ID = "org.eclipse.cdt.docker.launcher.gcc.provider";
    public static final String CONTAINER_LINUX_CONFIG_ID = "linux-container-id";
    private IToolChainManager toolChainManager;

    public String getId() {
        return PROVIDER_ID;
    }

    public synchronized void init(IToolChainManager manager) throws CoreException {
        this.toolChainManager = manager;
        IDockerConnection[] connections = DockerConnectionManager.getInstance().getConnections();
        HashMap<String, IDockerConnection> connectionMap = new HashMap<String, IDockerConnection>();
        IDockerConnection[] iDockerConnectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IDockerConnection connection = iDockerConnectionArray[n2];
            connectionMap.put(connection.getUri(), connection);
            List images = connection.getImages();
            for (IDockerImage image : images) {
                if (image.isDangling() || image.isIntermediateImage()) continue;
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("os", "linux-container");
                properties.put("arch", Platform.getOSArch());
                properties.put("connection_uri", connection.getUri());
                properties.put("image_id", (String)image.repoTags().get(0));
                properties.put(CONTAINER_LINUX_CONFIG_ID, ((String)image.repoTags().get(0)).replace(':', '_'));
                ContainerGCCToolChain toolChain = new ContainerGCCToolChain("gcc-img-" + image.id().substring(0, 19), this, properties, null);
                manager.addToolChain((IToolChain)toolChain);
            }
            ++n2;
        }
        DockerConnectionManager.getInstance().addConnectionManagerListener((IDockerConnectionManagerListener)this);
        ICBuildConfigurationManager mgr = (ICBuildConfigurationManager)CCorePlugin.getService(ICBuildConfigurationManager.class);
        ICBuildConfigurationManager2 cbuildmanager = (ICBuildConfigurationManager2)mgr;
        cbuildmanager.recheckConfigs();
    }

    public synchronized void changeEvent(final IDockerConnection connection, final int type) {
        final ContainerGCCToolChainProvider provider = this;
        Job checkConfigs = new Job("Check configs"){

            protected IStatus run(IProgressMonitor monitor) {
                ICBuildConfigurationManager mgr = (ICBuildConfigurationManager)CCorePlugin.getService(ICBuildConfigurationManager.class);
                ICBuildConfigurationManager2 manager = (ICBuildConfigurationManager2)mgr;
                if (type == 0 || type == 4) {
                    List images = connection.getImages();
                    for (IDockerImage image : images) {
                        if (image.isDangling() || image.isIntermediateImage()) continue;
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("os", "linux-container");
                        properties.put("arch", Platform.getOSArch());
                        properties.put("connection_uri", connection.getUri());
                        properties.put("image_id", (String)image.repoTags().get(0));
                        properties.put(ContainerGCCToolChainProvider.CONTAINER_LINUX_CONFIG_ID, ((String)image.repoTags().get(0)).replace(':', '_'));
                        try {
                            Collection toolChains = ContainerGCCToolChainProvider.this.toolChainManager.getToolChainsMatching(properties);
                            if (!toolChains.isEmpty()) continue;
                            ContainerGCCToolChain toolChain = new ContainerGCCToolChain("gcc-img-" + image.id().substring(0, 19), provider, properties, null);
                            ContainerGCCToolChainProvider.this.toolChainManager.addToolChain((IToolChain)toolChain);
                        }
                        catch (CoreException e) {
                            DockerLaunchUIPlugin.log(e);
                        }
                    }
                    manager.recheckConfigs();
                } else if (type == 1 || type == 5) {
                    try {
                        String connectionURI = connection.getUri();
                        Collection toolChains = ContainerGCCToolChainProvider.this.toolChainManager.getAllToolChains();
                        for (IToolChain toolChain : toolChains) {
                            String uri = toolChain.getProperty("connection_uri");
                            if (!connectionURI.equals(uri)) continue;
                            ContainerGCCToolChainProvider.this.toolChainManager.removeToolChain(toolChain);
                        }
                    }
                    catch (CoreException e1) {
                        DockerLaunchUIPlugin.log(e1);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        checkConfigs.setUser(true);
        checkConfigs.schedule();
    }
}

