/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.CMakeUtils;
import org.eclipse.cdt.cmake.core.internal.CompileCommand;
import org.eclipse.cdt.cmake.core.internal.Messages;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CMakeBuildConfiguration
extends CBuildConfiguration {
    public static final String CMAKE_GENERATOR = "cmake.generator";
    public static final String CMAKE_ARGUMENTS = "cmake.arguments";
    public static final String CMAKE_ENV = "cmake.environment";
    public static final String BUILD_COMMAND = "cmake.command.build";
    public static final String CLEAN_COMMAND = "cmake.command.clean";
    private static final String TOOLCHAIN_FILE = "cdt.cmake.toolchainfile";
    private ICMakeToolChainFile toolChainFile;

    public CMakeBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
        Preferences settings = this.getSettings();
        String pathStr = settings.get(TOOLCHAIN_FILE, "");
        if (!pathStr.isEmpty()) {
            java.nio.file.Path path = Paths.get(pathStr, new String[0]);
            this.toolChainFile = manager.getToolChainFile(path);
        } else {
            this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
            if (this.toolChainFile != null) {
                this.saveToolChainFile();
            }
        }
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this(config, name, toolChain, null, "run");
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, ICMakeToolChainFile toolChainFile, String launchMode) {
        super(config, name, toolChain, launchMode);
        this.toolChainFile = toolChainFile;
        if (toolChainFile != null) {
            this.saveToolChainFile();
        }
    }

    public ICMakeToolChainFile getToolChainFile() {
        return this.toolChainFile;
    }

    private void saveToolChainFile() {
        Preferences settings = this.getSettings();
        settings.put(TOOLCHAIN_FILE, this.toolChainFile.getPath().toString());
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    private boolean isLocal() throws CoreException {
        IToolChain toolchain = this.getToolChain();
        return (Platform.getOS().equals(toolchain.getProperty("os")) || "linux-container".equals(toolchain.getProperty("os"))) && Platform.getOSArch().equals(toolchain.getProperty("arch"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            boolean runCMake;
            String generator = this.getProperty(CMAKE_GENERATOR);
            if (generator == null) {
                generator = "Ninja";
            }
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            outStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingIn, buildDir.toString()));
            if (this.toolChainFile == null && !this.isLocal()) {
                ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
                this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
                if (this.toolChainFile == null) {
                    console.getErrorStream().write(Messages.CMakeBuildConfiguration_NoToolchainFile);
                    return null;
                }
            }
            switch (generator) {
                case "Ninja": {
                    runCMake = !Files.exists(buildDir.resolve("build.ninja"), new LinkOption[0]);
                    break;
                }
                default: {
                    boolean bl = runCMake = !Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0]);
                }
            }
            if (runCMake) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("cmake");
                command.add("-G");
                command.add(generator);
                if (this.toolChainFile != null) {
                    command.add("-DCMAKE_TOOLCHAIN_FILE=" + this.toolChainFile.getPath().toString());
                }
                switch (this.getLaunchMode()) {
                    case "debug": {
                        command.add("-DCMAKE_BUILD_TYPE=Debug");
                        break;
                    }
                    case "run": {
                        command.add("-DCMAKE_BUILD_TYPE=Release");
                        break;
                    }
                }
                command.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
                String userArgs = this.getProperty(CMAKE_ARGUMENTS);
                if (userArgs != null) {
                    command.addAll(Arrays.asList(userArgs.trim().split("\\s+")));
                }
                command.add(new File(project.getLocationURI()).getAbsolutePath());
                outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
                Path workingDir = new Path(this.getBuildDirectory().toString());
                Process p = this.startBuildProcess(command, new IEnvironmentVariable[0], (IPath)workingDir, console, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                    return null;
                }
                this.watchProcess(p, console);
            }
            Throwable throwable = null;
            String string = null;
            try {
                ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());
                try {
                    String buildCommand;
                    epm.setOutputStream((OutputStream)console.getOutputStream());
                    ArrayList<String> command = new ArrayList<String>();
                    String envStr = this.getProperty(CMAKE_ENV);
                    ArrayList<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
                    if (envStr != null) {
                        List<String> envList = CMakeUtils.stripEnvVars(envStr);
                        for (String s : envList) {
                            int index = s.indexOf("=");
                            if (index == -1) {
                                envVars.add(new EnvironmentVariable(s));
                                continue;
                            }
                            envVars.add(new EnvironmentVariable(s.substring(0, index), s.substring(index + 1)));
                        }
                    }
                    if ((buildCommand = this.getProperty(BUILD_COMMAND)) == null) {
                        command.add("cmake");
                        command.add("--build");
                        command.add(".");
                        if ("Ninja".equals(generator)) {
                            command.add("--");
                            command.add("-v");
                        }
                    } else {
                        command.addAll(Arrays.asList(buildCommand.split(" ")));
                    }
                    outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
                    Path workingDir = new Path(this.getBuildDirectory().toString());
                    Process p = this.startBuildProcess(command, envVars.toArray(new IEnvironmentVariable[0]), (IPath)workingDir, console, monitor);
                    if (p == null) {
                        console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                        return null;
                    }
                    this.watchProcess(p, new IConsoleParser[]{epm});
                    project.refreshLocal(2, monitor);
                    this.processCompileCommandsFile(monitor);
                    outStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingComplete, epm.getErrorCount(), epm.getWarningCount(), buildDir.toString()));
                    return new IProject[]{project};
                }
                finally {
                    if (epm == null) return null;
                    epm.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Building, project.getName()), e));
        }
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            String generator = this.getProperty(CMAKE_GENERATOR);
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            if (!Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0])) {
                outStream.write(Messages.CMakeBuildConfiguration_NotFound);
                return;
            }
            ArrayList<String> command = new ArrayList<String>();
            String cleanCommand = this.getProperty(CLEAN_COMMAND);
            if (cleanCommand == null) {
                if (generator == null || generator.equals("Ninja")) {
                    command.add("ninja");
                    command.add("clean");
                } else {
                    command.add("make");
                    command.add("clean");
                }
            } else {
                command.addAll(Arrays.asList(cleanCommand.split(" ")));
            }
            IEnvironmentVariable[] env = new IEnvironmentVariable[]{};
            outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
            Path workingDir = new Path(this.getBuildDirectory().toString());
            Process p = this.startBuildProcess(command, env, (IPath)workingDir, console, monitor);
            if (p == null) {
                console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                return;
            }
            this.watchProcess(p, console);
            outStream.write(Messages.CMakeBuildConfiguration_BuildComplete);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Cleaning, project.getName()), e));
        }
    }

    private void processCompileCommandsFile(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        java.nio.file.Path commandsFile = this.getBuildDirectory().resolve("compile_commands.json");
        if (Files.exists(commandsFile, new LinkOption[0])) {
            ArrayList jobsList = new ArrayList();
            monitor.setTaskName(Messages.CMakeBuildConfiguration_ProcCompJson);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileReader reader = new FileReader(commandsFile.toFile());){
                    Gson gson = new Gson();
                    CompileCommand[] commands = (CompileCommand[])gson.fromJson((Reader)reader, CompileCommand[].class);
                    HashMap<String, CompileCommand> dedupedCmds = new HashMap<String, CompileCommand>();
                    CompileCommand[] compileCommandArray = commands;
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CompileCommand command = compileCommandArray[n2];
                        dedupedCmds.put(command.getFile(), command);
                        ++n2;
                    }
                    for (CompileCommand command : dedupedCmds.values()) {
                        this.processLine(command.getCommand(), jobsList);
                    }
                    for (Job j : jobsList) {
                        try {
                            j.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.shutdown();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_ProcCompCmds, project.getName()), e));
            }
        }
    }
}

