/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

class TextMenuManager {
    private Hashtable htActions = new Hashtable();
    private MenuManager manager = new MenuManager();

    TextMenuManager(TextViewer viewer) {
        Separator separator = new Separator("undo");
        this.manager.add((IContributionItem)separator);
        separator = new Separator("copy");
        this.manager.add((IContributionItem)separator);
        separator = new Separator("select");
        this.manager.add((IContributionItem)separator);
        this.manager.appendToGroup("undo", (IAction)this.getAction("undo", viewer, JdbcPlugin.getResourceString("sqleditor.action.undo"), 1));
        this.manager.appendToGroup("undo", (IAction)this.getAction("redo", viewer, JdbcPlugin.getResourceString("sqleditor.action.redo"), 2));
        this.manager.appendToGroup("copy", (IAction)this.getAction("cut", viewer, JdbcPlugin.getResourceString("sqleditor.action.cut"), 3));
        this.manager.appendToGroup("copy", (IAction)this.getAction("copy", viewer, JdbcPlugin.getResourceString("sqleditor.action.copy"), 4));
        this.manager.appendToGroup("copy", (IAction)this.getAction("paste", viewer, JdbcPlugin.getResourceString("sqleditor.action.paste"), 5));
        this.manager.appendToGroup("select", (IAction)this.getAction("selectall", viewer, JdbcPlugin.getResourceString("sqleditor.action.selectAll"), 7));
        this.manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Enumeration elements = TextMenuManager.this.htActions.elements();
                while (elements.hasMoreElements()) {
                    SQLEditorAction action = (SQLEditorAction)((Object)elements.nextElement());
                    action.update();
                }
            }
        });
    }

    public Menu getContextMenu(Control control) {
        return this.manager.createContextMenu(control);
    }

    private final SQLEditorAction getAction(String id, TextViewer viewer, String name, int operation) {
        SQLEditorAction action = (SQLEditorAction)((Object)this.htActions.get(id));
        if (action == null) {
            action = new SQLEditorAction(viewer, name, operation);
            this.htActions.put(id, action);
        }
        return action;
    }

    static class SQLEditorAction
    extends Action {
        private int operationCode = -1;
        private TextViewer viewer = null;

        public SQLEditorAction(TextViewer viewer, String text, int operationCode) {
            super(text);
            this.operationCode = operationCode;
            this.viewer = viewer;
        }

        public void run() {
            this.viewer.doOperation(this.operationCode);
        }

        public void update() {
            this.setEnabled(this.viewer.canDoOperation(this.operationCode));
        }
    }
}

