/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.layer.cell;

import java.io.Serializable;
import java.util.List;
import net.sourceforge.nattable.data.IRowDataProvider;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.cell.AbstractOverrider;
import net.sourceforge.nattable.layer.cell.CellValueOverrideKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellOverrideLabelAccumulator<T>
extends AbstractOverrider {
    private IRowDataProvider<T> dataProvider;

    public CellOverrideLabelAccumulator(IRowDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        List<String> cellLabels = this.getConfigLabels(this.dataProvider.getDataValue(columnPosition, rowPosition), columnPosition);
        if (cellLabels == null) {
            return;
        }
        for (String configLabel : cellLabels) {
            configLabels.addLabel(configLabel);
        }
    }

    protected List<String> getConfigLabels(Object value, int col) {
        CellValueOverrideKey key = new CellValueOverrideKey(value, col);
        return this.getOverrides(key);
    }

    public void registerOverride(Object cellValue, int col, String configLabel) {
        this.registerOverrides((Serializable)new CellValueOverrideKey(cellValue, col), configLabel);
    }
}

