/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.sail.lucene.AbstractLuceneIndex;

public abstract class AbstractReaderMonitor {
    private final AtomicInteger readingCount = new AtomicInteger(0);
    private final AtomicBoolean doClose = new AtomicBoolean(false);
    private final AbstractLuceneIndex index;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    protected AbstractReaderMonitor(AbstractLuceneIndex index) {
        this.index = index;
    }

    public final int getReadingCount() {
        return this.readingCount.get();
    }

    public final synchronized void beginReading() {
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot begin reading as we have been closed.");
        }
        if (this.doClose.get()) {
            throw new IllegalStateException("Cannot begin reading as we have moved into closing stages.");
        }
        this.readingCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void endReading() throws IOException {
        if (this.readingCount.decrementAndGet() <= 0 && this.doClose.get()) {
            this.close();
            Collection<AbstractReaderMonitor> collection = this.index.oldmonitors;
            synchronized (collection) {
                this.index.oldmonitors.remove(this);
            }
        }
    }

    public final synchronized boolean closeWhenPossible() throws IOException {
        this.doClose.set(true);
        if (this.readingCount.get() == 0) {
            this.close();
        }
        return this.closed.get();
    }

    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.handleClose();
        }
    }

    protected abstract void handleClose() throws IOException;
}

