/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.Severity;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclPrefixParser;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

public class ValidationQuery {
    private final Set<Namespace> namespaces = new HashSet<Namespace>();
    private ValidationResultGenerator validationResultGenerator;
    private String query;
    private ConstraintComponent.Scope scope;
    private ConstraintComponent.Scope scope_validationReport;
    private final List<StatementMatcher.Variable<Value>> variables;
    private int targetIndex;
    private int valueIndex;
    private boolean propertyShapeWithValue;
    private boolean propertyShapeWithValue_validationReport;
    private int targetIndex_validationReport;
    private int valueIndex_validationReport;
    private ConstraintComponent constraintComponent;
    private ConstraintComponent constraintComponent_validationReport;
    private Severity severity;
    private Shape shape;
    private List<StatementMatcher.Variable<?>> extraVariables = List.of();

    public ValidationQuery(Collection<Namespace> namespaces, String query, List<StatementMatcher.Variable<Value>> targets, StatementMatcher.Variable<Value> value, ConstraintComponent.Scope scope, ConstraintComponent constraintComponent, Severity severity, Shape shape) {
        this.namespaces.addAll(namespaces);
        this.query = query;
        ArrayList<StatementMatcher.Variable<Value>> variables = new ArrayList<StatementMatcher.Variable<Value>>(targets);
        if (value != null) {
            variables.add(value);
        }
        this.variables = Collections.unmodifiableList(variables);
        if (scope == ConstraintComponent.Scope.propertyShape) {
            this.targetIndex = targets.size() - 1;
            if (value != null) {
                this.propertyShapeWithValue = true;
                this.valueIndex = variables.size() - 1;
                assert (constraintComponent == null || constraintComponent.getConstraintComponent().producesValidationResultValue());
            } else {
                this.propertyShapeWithValue = false;
                this.valueIndex = variables.size();
                assert (constraintComponent == null || !constraintComponent.getConstraintComponent().alwaysProducesValidationResultValue());
            }
        } else {
            this.targetIndex = variables.size() - 1;
            this.valueIndex = variables.size() - 1;
        }
        this.scope = scope;
        this.constraintComponent = constraintComponent;
        this.severity = severity;
        this.shape = shape;
        this.validationResultGenerator = new ValidationResultGenerator();
    }

    public ValidationQuery(Set<Namespace> namespaces, String query, ConstraintComponent.Scope scope, List<StatementMatcher.Variable<Value>> variables, int targetIndex, int valueIndex) {
        this.namespaces.addAll(namespaces);
        this.query = query;
        this.scope = scope;
        this.variables = Collections.unmodifiableList(variables);
        this.targetIndex = targetIndex;
        this.valueIndex = valueIndex;
        this.validationResultGenerator = new ValidationResultGenerator();
    }

    public static ValidationQuery union(ValidationQuery a, ValidationQuery b, boolean skipValueCheck) {
        if (a == Deactivated.instance) {
            return b;
        }
        if (b == Deactivated.instance) {
            return a;
        }
        assert (a.getTargetVariable(false).equals(b.getTargetVariable(false)));
        assert (skipValueCheck || !a.propertyShapeWithValue || !b.propertyShapeWithValue || a.getValueVariable(false).equals(b.getValueVariable(false)));
        assert (a.scope != ConstraintComponent.Scope.nodeShape || a.valueIndex == a.targetIndex);
        assert (b.scope != ConstraintComponent.Scope.nodeShape || b.valueIndex == b.targetIndex);
        assert (a.scope == b.scope);
        assert (a.targetIndex == b.targetIndex);
        assert (a.valueIndex == b.valueIndex);
        String unionQuery = "{\n" + a.getQuery() + "\n} UNION {\n" + b.query + "\n}";
        List<StatementMatcher.Variable<Value>> variables = a.variables.size() >= b.variables.size() ? a.variables : b.variables;
        HashSet<Namespace> namespaces = new HashSet<Namespace>();
        namespaces.addAll(a.namespaces);
        namespaces.addAll(b.namespaces);
        if (a.propertyShapeWithValue || a.scope == ConstraintComponent.Scope.nodeShape) {
            assert (a.variables.size() > a.valueIndex);
            return new ValidationQuery(namespaces, unionQuery, a.scope, variables.subList(0, a.valueIndex + 1), a.targetIndex, a.valueIndex);
        }
        assert (a.variables.size() >= a.valueIndex);
        return new ValidationQuery(namespaces, unionQuery, a.scope, a.variables.subList(0, a.valueIndex), a.targetIndex, a.valueIndex);
    }

    public String getQuery() {
        return this.query;
    }

    public PlanNode getValidationPlan(SailConnection baseConnection, Resource[] dataGraph, Resource[] shapesGraphs) {
        assert (this.query != null);
        assert (this.shape != null);
        assert (this.scope_validationReport != null);
        String fullQueryString = this.getFullQueryString();
        Select select = new Select(baseConnection, fullQueryString, bindings -> {
            Function<ValidationTuple, ValidationResult> validationResultFunction = this.validationResultGenerator.getValidationTupleValidationResultFunction(this, shapesGraphs, (BindingSet)bindings);
            ValidationTuple validationTuple = this.scope_validationReport == ConstraintComponent.Scope.propertyShape ? (this.propertyShapeWithValue_validationReport ? new ValidationTuple(bindings.getValue(this.getTargetVariable(true)), bindings.getValue(this.getValueVariable(true)), this.scope_validationReport, true, dataGraph) : new ValidationTuple(bindings.getValue(this.getTargetVariable(true)), this.scope_validationReport, false, dataGraph)) : new ValidationTuple(bindings.getValue(this.getTargetVariable(true)), this.scope_validationReport, true, dataGraph);
            return validationTuple.addValidationResult(validationResultFunction);
        }, dataGraph);
        return select;
    }

    public void setValidationResultGenerator(List<StatementMatcher.Variable<?>> extraVariables, ValidationResultGenerator validationResultGenerator) {
        this.validationResultGenerator = validationResultGenerator;
        this.extraVariables = extraVariables;
    }

    private String getFullQueryString() {
        Optional<String> reduce;
        Object extraVariablesString = !this.extraVariables.isEmpty() ? ((reduce = this.extraVariables.stream().map(StatementMatcher.Variable::asSparqlVariable).reduce((a, b) -> a + " " + b)).isPresent() ? reduce.get() + " " : "") : "";
        if (this.scope_validationReport == ConstraintComponent.Scope.propertyShape && this.propertyShapeWithValue_validationReport) {
            return ShaclPrefixParser.toSparqlPrefixes(this.namespaces) + "\nSELECT DISTINCT ?" + this.getTargetVariable(true) + " ?" + this.getValueVariable(true) + " " + (String)extraVariablesString + "WHERE {\n" + this.query + "\n}";
        }
        return ShaclPrefixParser.toSparqlPrefixes(this.namespaces) + "\nSELECT DISTINCT ?" + this.getTargetVariable(true) + " " + (String)extraVariablesString + "WHERE {\n" + this.query + "\n}";
    }

    private String getValueVariable(boolean forValidationReport) {
        if (forValidationReport) {
            return this.variables.get((int)this.valueIndex_validationReport).name;
        }
        assert (this.scope != ConstraintComponent.Scope.propertyShape || this.propertyShapeWithValue);
        return this.variables.get((int)this.valueIndex).name;
    }

    private String getTargetVariable(boolean forValidationReport) {
        if (forValidationReport) {
            return this.variables.get((int)this.targetIndex_validationReport).name;
        }
        return this.variables.get((int)this.targetIndex).name;
    }

    public ValidationQuery withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public ValidationQuery withShape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public void popTargetChain() {
        assert (this.scope == ConstraintComponent.Scope.propertyShape);
        this.propertyShapeWithValue = true;
        --this.targetIndex;
        --this.valueIndex;
    }

    public void shiftToNodeShape() {
        assert (this.scope == ConstraintComponent.Scope.propertyShape);
        this.scope = ConstraintComponent.Scope.nodeShape;
        this.propertyShapeWithValue = false;
        --this.valueIndex;
    }

    public void shiftToPropertyShape() {
        assert (this.scope == ConstraintComponent.Scope.nodeShape);
        this.scope = ConstraintComponent.Scope.propertyShape;
        this.propertyShapeWithValue = true;
        --this.targetIndex;
    }

    public ValidationQuery withConstraintComponent(ConstraintComponent constraintComponent) {
        this.constraintComponent = constraintComponent;
        return this;
    }

    public void makeCurrentStateValidationReport() {
        this.valueIndex_validationReport = this.valueIndex;
        this.targetIndex_validationReport = this.targetIndex;
        this.scope_validationReport = this.scope;
        this.constraintComponent_validationReport = this.constraintComponent;
        this.propertyShapeWithValue_validationReport = this.propertyShapeWithValue;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public ConstraintComponent getConstraintComponent_validationReport() {
        return this.constraintComponent_validationReport;
    }

    public static class ValidationResultGenerator {
        public Function<ValidationTuple, ValidationResult> getValidationTupleValidationResultFunction(ValidationQuery validationQuery, Resource[] shapesGraphs, BindingSet bindings) {
            return t -> new ValidationResult(t.getActiveTarget(), t.getValue(), validationQuery.shape, validationQuery.constraintComponent_validationReport, validationQuery.severity, t.getScope(), t.getContexts(), shapesGraphs);
        }
    }

    public static class Deactivated
    extends ValidationQuery {
        private static final Deactivated instance = new Deactivated();

        private Deactivated() {
            super(List.of(), "", Collections.emptyList(), null, null, null, null, null);
        }

        public static Deactivated getInstance() {
            return instance;
        }

        @Override
        public PlanNode getValidationPlan(SailConnection baseConnection, Resource[] dataGraph, Resource[] shapesGraphs) {
            return EmptyNode.getInstance();
        }

        @Override
        public ValidationQuery withSeverity(Severity severity) {
            return this;
        }

        @Override
        public ValidationQuery withShape(Shape shape) {
            return this;
        }

        @Override
        public void popTargetChain() {
        }

        @Override
        public void shiftToNodeShape() {
        }

        @Override
        public void shiftToPropertyShape() {
        }

        @Override
        public ValidationQuery withConstraintComponent(ConstraintComponent constraintComponent) {
            return this;
        }

        @Override
        public void makeCurrentStateValidationReport() {
        }
    }
}

