/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializerObjectArray;

public class SerializerClass
extends GroupSerializerObjectArray<Class<?>> {
    protected final ClassLoader classLoader;

    public SerializerClass(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SerializerClass() {
        this(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void serialize(DataOutput2 out, Class<?> value) throws IOException {
        out.writeUTF(value.getName());
    }

    @Override
    public Class<?> deserialize(DataInput2 in, int available) throws IOException {
        try {
            return this.classLoader.loadClass(in.readUTF());
        }
        catch (ClassNotFoundException e) {
            throw new DBException.SerializationError(e);
        }
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public boolean equals(Class<?> a1, Class<?> a2) {
        return a1 == a2 || a1.toString().equals(a2.toString());
    }

    @Override
    public int hashCode(Class<?> aClass, int seed) {
        return aClass.toString().hashCode();
    }
}

