/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import org.eclipse.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import org.eclipse.collections.impl.lazy.parallel.set.SynchronizedParallelUnsortedSetIterable;
import org.eclipse.collections.impl.set.mutable.SetAdapter;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;

public class SynchronizedMutableSet<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableSet<T>,
Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedMutableSet(MutableSet<T> set) {
        super(set);
    }

    SynchronizedMutableSet(MutableSet<T> set, Object newLock) {
        super(set, newLock);
    }

    public static <E, S extends Set<E>> SynchronizedMutableSet<E> of(S set) {
        return new SynchronizedMutableSet(SetAdapter.adapt(set));
    }

    public static <E, S extends Set<E>> SynchronizedMutableSet<E> of(S set, Object lock) {
        return new SynchronizedMutableSet(SetAdapter.adapt(set), lock);
    }

    private MutableSet<T> getMutableSet() {
        return (MutableSet)this.getDelegate();
    }

    public MutableSet<T> with(T element) {
        this.add(element);
        return this;
    }

    public MutableSet<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableSet<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getMutableSet().clone());
        }
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy<T>(this.getMutableSet());
    }

    @Override
    public MutableSet<T> tap(Procedure<? super T> procedure) {
        return (MutableSet)super.tap(procedure);
    }

    @Override
    public MutableSet<T> select(Predicate<? super T> predicate) {
        return (MutableSet)super.select(predicate);
    }

    @Override
    public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableSet)super.selectWith(predicate, parameter);
    }

    @Override
    public MutableSet<T> reject(Predicate<? super T> predicate) {
        return (MutableSet)super.reject(predicate);
    }

    @Override
    public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableSet)super.rejectWith(predicate, parameter);
    }

    @Override
    public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
        return (PartitionMutableSet)super.partition(predicate);
    }

    @Override
    public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (PartitionMutableSet)super.partitionWith(predicate, parameter);
    }

    public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return (MutableBooleanSet)super.collectBoolean(booleanFunction);
    }

    public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        return (MutableByteSet)super.collectByte(byteFunction);
    }

    public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
        return (MutableCharSet)super.collectChar(charFunction);
    }

    public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        return (MutableDoubleSet)super.collectDouble(doubleFunction);
    }

    public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        return (MutableFloatSet)super.collectFloat(floatFunction);
    }

    public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
        return (MutableIntSet)super.collectInt(intFunction);
    }

    public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
        return (MutableLongSet)super.collectLong(longFunction);
    }

    public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        return (MutableShortSet)super.collectShort(shortFunction);
    }

    @Override
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        return (MutableSet)super.selectInstancesOf(clazz);
    }

    @Override
    public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
        return (MutableSet)super.collect(function);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return (MutableSet)super.zipWithIndex();
    }

    @Override
    public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return (MutableSet)super.collectWith(function, parameter);
    }

    @Override
    public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return (MutableSet)super.collectIf(predicate, function);
    }

    @Override
    public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableSet)super.flatCollect(function);
    }

    @Override
    public <V> MutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return (MutableSetMultimap)super.groupBy(function);
    }

    @Override
    public <V> MutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableSetMultimap)super.groupByEach(function);
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        return (MutableSet)super.zip(that);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getMutableSet().unionInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getMutableSet().intersectInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getMutableSet().differenceInto(subtrahendSet, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getMutableSet().symmetricDifferenceInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().isSubsetOf(candidateSuperset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().isProperSubsetOf(candidateSuperset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().cartesianProduct(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> union(SetIterable<? extends T> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().union(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().intersect(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().difference(subtrahendSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().symmetricDifference(setB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().powerSet();
        }
    }

    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new SynchronizedParallelUnsortedSetIterable(this.getMutableSet().asParallel(executorService, batchSize), this.getLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableMutableSet.of(this);
        }
    }

    public MutableSet<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<T> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return Sets.immutable.withAll(this.getMutableSet());
        }
    }
}

