/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.context;

import jakarta.json.JsonObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.JsonLdVersion;
import no.hasmac.jsonld.compaction.UriCompaction;
import no.hasmac.jsonld.compaction.ValueCompaction;
import no.hasmac.jsonld.context.ActiveContextBuilder;
import no.hasmac.jsonld.context.InverseContext;
import no.hasmac.jsonld.context.InverseContextBuilder;
import no.hasmac.jsonld.context.TermDefinition;
import no.hasmac.jsonld.context.TermDefinitionBuilder;
import no.hasmac.jsonld.context.TermSelector;
import no.hasmac.jsonld.expansion.UriExpansion;
import no.hasmac.jsonld.expansion.ValueExpansion;
import no.hasmac.jsonld.lang.DirectionType;

public final class ActiveContext {
    private final Map<String, TermDefinition> terms;
    private URI baseUri;
    private URI baseUrl;
    private InverseContext inverseContext;
    private ActiveContext previousContext;
    private String vocabularyMapping;
    private String defaultLanguage;
    private DirectionType defaultBaseDirection;
    private final JsonLdOptions options;
    private final List<CachedPrefix> prefixCache = new ArrayList<CachedPrefix>(10);

    public ActiveContext(JsonLdOptions options) {
        this(null, null, null, options);
    }

    public ActiveContext(URI baseUri, URI baseUrl, JsonLdOptions options) {
        this(baseUri, baseUrl, null, options);
    }

    public ActiveContext(URI baseUri, URI baseUrl, ActiveContext previousContext, JsonLdOptions options) {
        this.baseUri = baseUri;
        this.baseUrl = baseUrl;
        this.previousContext = previousContext;
        this.terms = new LinkedHashMap<String, TermDefinition>();
        this.options = options;
    }

    public ActiveContext(ActiveContext origin) {
        this.terms = new LinkedHashMap<String, TermDefinition>(origin.terms);
        this.baseUri = origin.baseUri;
        this.baseUrl = origin.baseUrl;
        this.inverseContext = origin.inverseContext;
        this.previousContext = origin.previousContext;
        this.vocabularyMapping = origin.vocabularyMapping;
        this.defaultLanguage = origin.defaultLanguage;
        this.defaultBaseDirection = origin.defaultBaseDirection;
        this.options = origin.options;
    }

    public void createInverseContext() {
        this.inverseContext = InverseContextBuilder.with(this).build();
    }

    public boolean containsTerm(String term) {
        return this.terms.containsKey(term);
    }

    public boolean containsProtectedTerm() {
        return this.terms.values().stream().anyMatch(TermDefinition::isProtected);
    }

    protected Optional<TermDefinition> removeTerm(String term) {
        if (this.terms.containsKey(term)) {
            return Optional.of(this.terms.remove(term));
        }
        return Optional.empty();
    }

    public Optional<TermDefinition> getTerm(String value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.terms.get(value));
    }

    public TermDefinition getTermNullable(String value) {
        if (value == null) {
            return null;
        }
        return this.terms.get(value);
    }

    public DirectionType getDefaultBaseDirection() {
        return this.defaultBaseDirection;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getVocabularyMapping() {
        return this.vocabularyMapping;
    }

    public boolean inMode(JsonLdVersion version) {
        return this.options.getProcessingMode() != null && this.options.getProcessingMode().equals((Object)version);
    }

    public ActiveContext getPreviousContext() {
        return this.previousContext;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public InverseContext getInverseContext() {
        return this.inverseContext;
    }

    public Map<String, TermDefinition> getTermsMapping() {
        return this.terms;
    }

    public Collection<String> getTerms() {
        return this.terms.keySet();
    }

    public ActiveContextBuilder newContext() {
        return ActiveContextBuilder.with(this);
    }

    public UriExpansion uriExpansion() {
        return UriExpansion.with(this).uriValidation(this.options.isUriValidation());
    }

    public ValueExpansion valueExpansion() {
        return ValueExpansion.with(this);
    }

    public UriCompaction uriCompaction() {
        return UriCompaction.with(this);
    }

    public ValueCompaction valueCompaction() {
        return ValueCompaction.with(this);
    }

    public TermDefinitionBuilder newTerm(JsonObject localContext, Map<String, Boolean> defined) {
        return TermDefinitionBuilder.with(this, localContext, defined);
    }

    public TermSelector termSelector(String variable, Collection<String> containerMapping, String typeLanguage) {
        return TermSelector.with(this, variable, containerMapping, typeLanguage);
    }

    public JsonLdOptions getOptions() {
        return this.options;
    }

    protected void setDefaultBaseDirection(DirectionType defaultBaseDirection) {
        this.defaultBaseDirection = defaultBaseDirection;
    }

    protected void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    protected void setVocabularyMapping(String vocabularyMapping) {
        this.vocabularyMapping = vocabularyMapping;
    }

    protected void setBaseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected void setPreviousContext(ActiveContext previousContext) {
        this.previousContext = previousContext;
    }

    protected void setInverseContext(InverseContext inverseContext) {
        this.inverseContext = inverseContext;
    }

    protected void setTerm(String term, TermDefinition definition) {
        this.terms.put(term, definition);
    }

    public String toString() {
        return "ActiveContext[terms=" + String.valueOf(this.terms) + ", previousContext=" + String.valueOf(this.previousContext) + "]";
    }

    public TermDefinition getPrefix(String prefix) {
        if (prefix == null) {
            return null;
        }
        if (this.prefixCache.size() <= 10) {
            for (CachedPrefix cachedPrefix : this.prefixCache) {
                if (!cachedPrefix.prefix.equals(prefix)) continue;
                return cachedPrefix.termDefinition;
            }
        } else {
            this.prefixCache.clear();
        }
        TermDefinition termDefinition = this.terms.get(prefix);
        if (termDefinition != null) {
            this.prefixCache.add(new CachedPrefix(prefix, termDefinition));
        }
        return termDefinition;
    }

    private static class CachedPrefix {
        private final String prefix;
        private final TermDefinition termDefinition;

        private CachedPrefix(String prefix, TermDefinition termDefinition) {
            this.prefix = prefix;
            this.termDefinition = termDefinition;
        }
    }
}

