/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.monitoring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.rdf4j.federated.FedXConfig;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.monitoring.MonitoringService;
import org.eclipse.rdf4j.federated.monitoring.QueryLog;
import org.eclipse.rdf4j.federated.monitoring.QueryPlanLog;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class MonitoringImpl
implements MonitoringService {
    private final Map<Endpoint, MonitoringInformation> requestMap = new ConcurrentHashMap<Endpoint, MonitoringInformation>();
    private final QueryLog queryLog;
    private final FedXConfig config;

    MonitoringImpl(FedXConfig config) {
        this.config = config;
        this.queryLog = config.isLogQueries() ? new QueryLog() : null;
    }

    @Override
    public void monitorRemoteRequest(Endpoint e) {
        MonitoringInformation m = this.requestMap.get(e);
        if (m == null) {
            m = new MonitoringInformation(e);
            this.requestMap.put(e, m);
        }
        m.increaseRequests();
    }

    @Override
    public MonitoringInformation getMonitoringInformation(Endpoint e) {
        return this.requestMap.get(e);
    }

    @Override
    public List<MonitoringInformation> getAllMonitoringInformation() {
        return new ArrayList<MonitoringInformation>(this.requestMap.values());
    }

    @Override
    public void resetMonitoringInformation() {
        this.requestMap.clear();
    }

    @Override
    public void monitorQuery(QueryInfo query) {
        if (this.queryLog != null) {
            this.queryLog.logQuery(query);
        }
    }

    @Override
    public void logQueryPlan(TupleExpr tupleExpr) {
        if (this.config.isLogQueryPlan()) {
            QueryPlanLog.setQueryPlan(tupleExpr);
        }
    }

    public static class MonitoringInformation {
        private final Endpoint e;
        private int numberOfRequests = 0;

        public MonitoringInformation(Endpoint e) {
            this.e = e;
        }

        private void increaseRequests() {
            ++this.numberOfRequests;
        }

        public String toString() {
            return this.e.getName() + " => " + this.numberOfRequests;
        }

        public Endpoint getE() {
            return this.e;
        }

        public int getNumberOfRequests() {
            return this.numberOfRequests;
        }
    }
}

