/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterByPredicateObject;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ReduceTargets;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class ClassConstraintComponent
extends AbstractConstraintComponent {
    private final IRI clazz;
    private final Set<Resource> clazzSet;

    public ClassConstraintComponent(IRI clazz) {
        this.clazz = clazz;
        this.clazzSet = Set.of(clazz);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.CLASS, this.clazz, new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.ClassConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new ClassConstraintComponent(this.clazz);
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode addedTargets;
            Path path = this.getTargetChain().getPath().get();
            if (overrideTargetNode != null) {
                addedTargets = effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            } else {
                BufferedSplitter addedTargetsBufferedSplitter = new BufferedSplitter(effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null));
                addedTargets = addedTargetsBufferedSplitter.getPlanNode();
                PlanNode addedByPath = path.getAllAdded(connectionsGroup, validationSettings.getDataGraph(), null);
                addedByPath = effectiveTarget.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), Unique.getInstance(new TrimToTarget(addedByPath), false));
                addedByPath = new ReduceTargets(addedByPath, addedTargetsBufferedSplitter.getPlanNode());
                addedByPath = effectiveTarget.extend(addedByPath, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, false, null);
                if (connectionsGroup.getStats().hasRemoved()) {
                    PlanNode deletedTypes = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, RDF.TYPE, this.clazz, validationSettings.getDataGraph(), UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape), null);
                    deletedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(deletedTypes, connectionsGroup, validationSettings.getDataGraph(), ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
                    deletedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), deletedTypes);
                    addedTargets = UnionNode.getInstance(addedTargets, new TrimToTarget(new ShiftToPropertyShape(deletedTypes)));
                }
                addedTargets = UnionNode.getInstance(addedByPath, addedTargets);
                addedTargets = Unique.getInstance(addedTargets, false);
            }
            PlanNode falseNode = new BulkedExternalInnerJoin(addedTargets, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), false, null, BulkedExternalInnerJoin.getMapper("a", "c", scope, validationSettings.getDataGraph()));
            if (connectionsGroup.getAddedStatements() != null) {
                falseNode = new FilterByPredicateObject(connectionsGroup.getAddedStatements(), validationSettings.getDataGraph(), RDF.TYPE, this.clazzSet, falseNode, false, FilterByPredicateObject.FilterOn.value, false);
            }
            falseNode = new FilterByPredicateObject(connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), RDF.TYPE, this.clazzSet, falseNode, false, FilterByPredicateObject.FilterOn.value, true);
            return falseNode;
        }
        if (scope == ConstraintComponent.Scope.nodeShape) {
            PlanNode addedTargets;
            if (overrideTargetNode != null) {
                addedTargets = effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            } else {
                addedTargets = effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
                if (connectionsGroup.getStats().hasRemoved()) {
                    PlanNode deletedTypes = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, RDF.TYPE, this.clazz, validationSettings.getDataGraph(), UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), null);
                    deletedTypes = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), deletedTypes);
                    deletedTypes = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(deletedTypes, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, false, null);
                    addedTargets = UnionNode.getInstance(addedTargets, deletedTypes);
                }
            }
            FilterByPredicateObject falseNode = new FilterByPredicateObject(connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), RDF.TYPE, this.clazzSet, addedTargets, false, FilterByPredicateObject.FilterOn.value, true);
            return falseNode;
        }
        throw new UnsupportedOperationException("Unknown scope: " + scope);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            if (connectionsGroup.getStats().hasRemoved()) {
                PlanNode deletedTypes = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, RDF.TYPE, this.clazz, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape), null);
                deletedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, deletedTypes);
                deletedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(deletedTypes, connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
                allTargetsPlan = UnionNode.getInstanceDedupe(allTargetsPlan, deletedTypes);
            }
            if (connectionsGroup.getStats().hasAdded()) {
                PlanNode addedTypes = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, RDF.TYPE, this.clazz, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape), null);
                addedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, addedTypes);
                addedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(addedTypes, connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
                allTargetsPlan = UnionNode.getInstanceDedupe(allTargetsPlan, addedTypes);
            }
            return Unique.getInstance(new TrimToTarget(new ShiftToPropertyShape(allTargetsPlan)), false);
        }
        PlanNode allTargetsPlan = EmptyNode.getInstance();
        if (connectionsGroup.getStats().hasRemoved()) {
            PlanNode deletedTypes = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, RDF.TYPE, this.clazz, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape), null);
            deletedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, deletedTypes);
            deletedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(deletedTypes, connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
            allTargetsPlan = UnionNode.getInstanceDedupe(allTargetsPlan, deletedTypes);
        }
        if (connectionsGroup.getStats().hasAdded()) {
            PlanNode addedTypes = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, RDF.TYPE, this.clazz, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape), null);
            addedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, addedTypes);
            addedTypes = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(addedTypes, connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
            allTargetsPlan = UnionNode.getInstanceDedupe(allTargetsPlan, addedTypes);
        }
        return Unique.getInstance(allTargetsPlan, false);
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Resource[] dataGraph, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return super.requiresEvaluation(connectionsGroup, scope, dataGraph, stableRandomVariableProvider) || connectionsGroup.getRemovedStatements().hasStatement(null, RDF.TYPE, this.clazz, true, dataGraph) || connectionsGroup.getAddedStatements().hasStatement(null, RDF.TYPE, this.clazz, true, dataGraph);
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        StatementMatcher.Variable<String> value;
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Object query = effectiveTarget.getQuery(false);
        if (scope == ConstraintComponent.Scope.nodeShape) {
            value = null;
            StatementMatcher.Variable<Value> target = effectiveTarget.getTargetVar();
            query = (String)query + "\n" + this.getFilter(connectionsGroup, target);
        } else {
            value = new StatementMatcher.Variable<String>("value");
            SparqlFragment sparqlFragment = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of())).orElseThrow(IllegalStateException::new);
            String pathQuery = sparqlFragment.getFragment();
            query = (String)query + "\n" + pathQuery;
            query = (String)query + "\n" + this.getFilter(connectionsGroup, value);
        }
        List<StatementMatcher.Variable<Value>> allTargetVariables = effectiveTarget.getAllTargetVariables();
        return new ValidationQuery(this.getTargetChain().getNamespaces(), (String)query, allTargetVariables, value, scope, this, null, null);
    }

    private String getFilter(ConnectionsGroup connectionsGroup, StatementMatcher.Variable<Value> target) {
        RdfsSubClassOfReasoner rdfsSubClassOfReasoner = connectionsGroup.getRdfsSubClassOfReasoner();
        Set<Resource> allClasses = rdfsSubClassOfReasoner != null ? rdfsSubClassOfReasoner.backwardsChain(this.clazz) : this.clazzSet;
        String condition = allClasses.stream().map(c -> "EXISTS{" + target.asSparqlVariable() + " a <" + c.stringValue() + ">}").reduce((a, b) -> a + " || " + b).orElseThrow(IllegalStateException::new);
        return "FILTER(!(" + condition + "))";
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return ValidationApproach.SPARQL;
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassConstraintComponent that = (ClassConstraintComponent)o;
        return this.clazz.equals(that.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode() + "ClassConstraintComponent".hashCode();
    }
}

