/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.sail.memory.model.MemLiteral;

public class IntegerMemLiteral
extends MemLiteral {
    private static final long serialVersionUID = -8121416400439616510L;
    private final BigInteger value;

    public IntegerMemLiteral(Object creator, BigInteger value) {
        this(creator, value, (CoreDatatype)CoreDatatype.XSD.INTEGER);
    }

    public IntegerMemLiteral(Object creator, BigInteger value, IRI datatype) {
        this(creator, value.toString(), value, datatype);
    }

    public IntegerMemLiteral(Object creator, BigInteger value, CoreDatatype datatype) {
        this(creator, value.toString(), value, datatype);
    }

    public IntegerMemLiteral(Object creator, String label, BigInteger value, IRI datatype) {
        super(creator, label, datatype);
        this.value = value;
    }

    public IntegerMemLiteral(Object creator, String label, BigInteger value, CoreDatatype datatype) {
        super(creator, label, datatype);
        this.value = value;
    }

    public byte byteValue() {
        return this.value.byteValue();
    }

    public short shortValue() {
        return this.value.shortValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigInteger integerValue() {
        return this.value;
    }

    public BigDecimal decimalValue() {
        return new BigDecimal(this.value);
    }
}

