/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.DefaultWktWriter;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.JtsSpatialAlgebra;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialAlgebra;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.WktWriter;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;

abstract class SpatialSupport {
    private static final SpatialContext spatialContext;
    private static final SpatialAlgebra spatialAlgebra;
    private static final WktWriter wktWriter;

    SpatialSupport() {
    }

    static SpatialContext getSpatialContext() {
        return spatialContext;
    }

    static SpatialAlgebra getSpatialAlgebra() {
        return spatialAlgebra;
    }

    static WktWriter getWktWriter() {
        return wktWriter;
    }

    protected abstract SpatialContext createSpatialContext();

    protected abstract SpatialAlgebra createSpatialAlgebra();

    protected abstract WktWriter createWktWriter();

    static {
        SpatialSupport support;
        try {
            Class<?> cls = Class.forName("org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupportInitializer", true, Thread.currentThread().getContextClassLoader());
            support = (SpatialSupport)cls.newInstance();
        }
        catch (Exception e) {
            support = new JtsSpatialSupport();
        }
        spatialContext = support.createSpatialContext();
        spatialAlgebra = support.createSpatialAlgebra();
        wktWriter = support.createWktWriter();
    }

    private static final class JtsSpatialSupport
    extends SpatialSupport {
        private JtsSpatialSupport() {
        }

        protected JtsSpatialContext createSpatialContext() {
            return JtsSpatialContext.GEO;
        }

        @Override
        protected JtsSpatialAlgebra createSpatialAlgebra() {
            return new JtsSpatialAlgebra((JtsSpatialContext)spatialContext);
        }

        @Override
        protected WktWriter createWktWriter() {
            return new DefaultWktWriter(spatialContext);
        }
    }
}

