/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIterationSpliterator;

public class Iterations {
    public static <E> List<E> asList(CloseableIteration<? extends E> iteration) {
        try (CloseableIteration<E> closeableIteration = iteration;){
            ArrayList list = new ArrayList();
            List list2 = Iterations.addAll(iteration, list);
            return list2;
        }
    }

    public static <E> Set<E> asSet(CloseableIteration<? extends E> iteration) {
        try (Stream<E> stream = iteration.stream();){
            Set set = stream.collect(Collectors.toSet());
            return set;
        }
    }

    public static <E, C extends Collection<E>> C addAll(CloseableIteration<? extends E> iteration, C collection) {
        try (CloseableIteration<E> closeableIteration = iteration;){
            while (iteration.hasNext()) {
                collection.add(iteration.next());
            }
        }
        return collection;
    }

    public static <T> Stream<T> stream(CloseableIteration<T> iteration) {
        return (Stream)StreamSupport.stream(new CloseableIterationSpliterator<T>(iteration), false).onClose(() -> {
            try {
                iteration.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new RuntimeException(e);
            }
        });
    }

    public static String toString(CloseableIteration<?> iteration, String separator) {
        try (CloseableIteration<?> closeableIteration = iteration;){
            StringBuilder sb = new StringBuilder();
            Iterations.toString(iteration, separator, sb);
            String string = sb.toString();
            return string;
        }
    }

    public static void toString(CloseableIteration<?> iteration, String separator, StringBuilder sb) {
        try (CloseableIteration<?> closeableIteration = iteration;){
            while (iteration.hasNext()) {
                sb.append(iteration.next());
                if (!iteration.hasNext()) continue;
                sb.append(separator);
            }
        }
    }

    public static <E> Set<E> asSet(CloseableIteration<? extends E> iteration, Supplier<Set<E>> setMaker) {
        try (CloseableIteration<E> closeableIteration = iteration;){
            Set set = setMaker.get();
            while (iteration.hasNext()) {
                set.add(iteration.next());
            }
            Set set2 = set;
            return set2;
        }
    }
}

