/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.btree;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.sail.nativerdf.btree.BTree;
import org.eclipse.rdf4j.sail.nativerdf.btree.Node;
import org.eclipse.rdf4j.sail.nativerdf.btree.NodeListener;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;

class RangeIterator
implements RecordIterator,
NodeListener {
    private final BTree tree;
    private final byte[] searchKey;
    private final byte[] searchMask;
    private final byte[] minValue;
    private final byte[] maxValue;
    private volatile boolean started;
    private volatile Node currentNode;
    private final AtomicBoolean revisitValue = new AtomicBoolean();
    private final LinkedList<Node> parentNodeStack = new LinkedList();
    private final LinkedList<Integer> parentIndexStack = new LinkedList();
    private volatile int currentIdx;
    private volatile boolean closed = false;

    public RangeIterator(BTree tree, byte[] searchKey, byte[] searchMask, byte[] minValue, byte[] maxValue) {
        this.tree = tree;
        this.searchKey = searchKey;
        this.searchMask = searchMask;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.started = false;
    }

    @Override
    public byte[] next() throws IOException {
        this.tree.btreeLock.readLock().lock();
        try {
            if (!this.started) {
                this.started = true;
                this.findMinimum();
            }
            byte[] value = this.findNext(this.revisitValue.getAndSet(false));
            while (value != null) {
                if (this.maxValue != null && this.tree.comparator.compareBTreeValues(this.maxValue, value, 0, value.length) < 0) {
                    this.close();
                    value = null;
                    break;
                }
                if (this.searchKey == null || ByteArrayUtil.matchesPattern((byte[])value, (byte[])this.searchMask, (byte[])this.searchKey)) break;
                value = this.findNext(false);
            }
            byte[] byArray = value;
            return byArray;
        }
        finally {
            this.tree.btreeLock.readLock().unlock();
        }
    }

    private void findMinimum() {
        this.currentNode = this.tree.readRootNode();
        Node nextCurrentNode = this.currentNode;
        if (nextCurrentNode == null) {
            return;
        }
        nextCurrentNode.register(this);
        this.currentIdx = 0;
        while (true) {
            if (this.minValue != null) {
                this.currentIdx = nextCurrentNode.search(this.minValue);
                if (this.currentIdx >= 0) break;
                this.currentIdx = -this.currentIdx - 1;
            }
            if (nextCurrentNode.isLeaf()) break;
            Node childNode = nextCurrentNode.getChildNode(this.currentIdx);
            this.pushStacks(childNode);
            nextCurrentNode = this.currentNode;
        }
    }

    private byte[] findNext(boolean returnedFromRecursion) throws IOException {
        Node nextCurrentNode = this.currentNode;
        if (nextCurrentNode == null) {
            return null;
        }
        if (returnedFromRecursion || nextCurrentNode.isLeaf()) {
            if (this.currentIdx >= nextCurrentNode.getValueCount()) {
                this.popStacks();
                return this.findNext(true);
            }
            return nextCurrentNode.getValue(this.currentIdx++);
        }
        Node childNode = nextCurrentNode.getChildNode(this.currentIdx);
        this.pushStacks(childNode);
        return this.findNext(false);
    }

    @Override
    public void set(byte[] value) {
        this.tree.btreeLock.readLock().lock();
        try {
            Node nextCurrentNode = this.currentNode;
            if (nextCurrentNode == null || this.currentIdx > nextCurrentNode.getValueCount()) {
                throw new IllegalStateException();
            }
            nextCurrentNode.setValue(this.currentIdx - 1, value);
        }
        finally {
            this.tree.btreeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            RangeIterator rangeIterator = this;
            synchronized (rangeIterator) {
                if (!this.closed) {
                    this.closed = true;
                    this.tree.btreeLock.readLock().lock();
                    try {
                        while (this.popStacks()) {
                        }
                        assert (this.parentNodeStack.isEmpty());
                        assert (this.parentIndexStack.isEmpty());
                    }
                    finally {
                        this.tree.btreeLock.readLock().unlock();
                    }
                }
            }
        }
    }

    private void pushStacks(Node newChildNode) {
        newChildNode.register(this);
        this.parentNodeStack.add(this.currentNode);
        this.parentIndexStack.add(this.currentIdx);
        this.currentNode = newChildNode;
        this.currentIdx = 0;
    }

    private synchronized boolean popStacks() throws IOException {
        Node nextCurrentNode = this.currentNode;
        if (nextCurrentNode == null) {
            return false;
        }
        nextCurrentNode.deregister(this);
        nextCurrentNode.release();
        if (!this.parentNodeStack.isEmpty()) {
            this.currentNode = this.parentNodeStack.removeLast();
            this.currentIdx = this.parentIndexStack.removeLast();
            return true;
        }
        this.currentNode = null;
        this.currentIdx = 0;
        return false;
    }

    @Override
    public boolean valueAdded(Node node, int addedIndex) {
        block3: {
            block2: {
                assert (this.tree.btreeLock.isWriteLockedByCurrentThread());
                if (node != this.currentNode) break block2;
                if (addedIndex >= this.currentIdx) break block3;
                ++this.currentIdx;
                break block3;
            }
            for (int i = 0; i < this.parentNodeStack.size(); ++i) {
                if (node != this.parentNodeStack.get(i)) continue;
                int parentIdx = this.parentIndexStack.get(i);
                if (addedIndex >= parentIdx) break;
                this.parentIndexStack.set(i, parentIdx + 1);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean valueRemoved(Node node, int removedIndex) {
        block3: {
            block2: {
                assert (this.tree.btreeLock.isWriteLockedByCurrentThread());
                if (node != this.currentNode) break block2;
                if (removedIndex >= this.currentIdx) break block3;
                --this.currentIdx;
                break block3;
            }
            for (int i = 0; i < this.parentNodeStack.size(); ++i) {
                if (node != this.parentNodeStack.get(i)) continue;
                int parentIdx = this.parentIndexStack.get(i);
                if (removedIndex >= parentIdx) break;
                this.parentIndexStack.set(i, parentIdx - 1);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean rotatedLeft(Node node, int valueIndex, Node leftChildNode, Node rightChildNode) throws IOException {
        block3: {
            block4: {
                Node nextCurrentNode;
                block2: {
                    nextCurrentNode = this.currentNode;
                    if (nextCurrentNode != node) break block2;
                    if (valueIndex != this.currentIdx - 1) break block3;
                    this.currentIdx = valueIndex;
                    this.revisitValue.set(true);
                    if (!node.isLeaf()) {
                        this.pushStacks(leftChildNode);
                        leftChildNode.use();
                    }
                    break block3;
                }
                if (nextCurrentNode != rightChildNode) break block4;
                if (this.currentIdx != 0) break block3;
                this.popStacks();
                this.currentIdx = valueIndex;
                this.revisitValue.set(true);
                break block3;
            }
            for (int i = 0; i < this.parentNodeStack.size(); ++i) {
                Node stackNode = this.parentNodeStack.get(i);
                if (stackNode != rightChildNode) continue;
                int stackIdx = this.parentIndexStack.get(i);
                if (stackIdx != 0) break;
                rightChildNode.deregister(this);
                rightChildNode.release();
                leftChildNode.use();
                leftChildNode.register(this);
                this.parentNodeStack.set(i, leftChildNode);
                this.parentIndexStack.set(i, leftChildNode.getValueCount());
                break;
            }
        }
        return false;
    }

    @Override
    public boolean rotatedRight(Node node, int valueIndex, Node leftChildNode, Node rightChildNode) throws IOException {
        for (int i = 0; i < this.parentNodeStack.size(); ++i) {
            Node stackNode = this.parentNodeStack.get(i);
            if (stackNode != leftChildNode) continue;
            int stackIdx = this.parentIndexStack.get(i);
            if (stackIdx != leftChildNode.getValueCount()) break;
            leftChildNode.deregister(this);
            leftChildNode.release();
            rightChildNode.use();
            rightChildNode.register(this);
            this.parentNodeStack.set(i, rightChildNode);
            this.parentIndexStack.set(i, 0);
            break;
        }
        return false;
    }

    @Override
    public boolean nodeSplit(Node node, Node newNode, int medianIdx) throws IOException {
        boolean deregister;
        block3: {
            block2: {
                assert (this.tree.btreeLock.isWriteLockedByCurrentThread());
                deregister = false;
                Node nextCurrentNode = this.currentNode;
                if (node != nextCurrentNode) break block2;
                if (this.currentIdx <= medianIdx) break block3;
                nextCurrentNode.release();
                deregister = true;
                newNode.use();
                newNode.register(this);
                this.currentNode = newNode;
                this.currentIdx -= medianIdx + 1;
                break block3;
            }
            for (int i = 0; i < this.parentNodeStack.size(); ++i) {
                Node parentNode = this.parentNodeStack.get(i);
                if (node != parentNode) continue;
                int parentIdx = this.parentIndexStack.get(i);
                if (parentIdx <= medianIdx) break;
                parentNode.release();
                deregister = true;
                newNode.use();
                newNode.register(this);
                this.parentNodeStack.set(i, newNode);
                this.parentIndexStack.set(i, parentIdx - medianIdx - 1);
                break;
            }
        }
        return deregister;
    }

    @Override
    public boolean nodeMergedWith(Node sourceNode, Node targetNode, int mergeIdx) throws IOException {
        assert (this.tree.btreeLock.isWriteLockedByCurrentThread());
        boolean deregister = false;
        Node nextCurrentNode = this.currentNode;
        if (sourceNode == nextCurrentNode) {
            nextCurrentNode.release();
            deregister = true;
            targetNode.use();
            targetNode.register(this);
            this.currentNode = targetNode;
            this.currentIdx += mergeIdx;
        } else {
            for (int i = 0; i < this.parentNodeStack.size(); ++i) {
                Node parentNode = this.parentNodeStack.get(i);
                if (sourceNode != parentNode) continue;
                parentNode.release();
                deregister = true;
                targetNode.use();
                targetNode.register(this);
                this.parentNodeStack.set(i, targetNode);
                this.parentIndexStack.set(i, mergeIdx + this.parentIndexStack.get(i));
                break;
            }
        }
        return deregister;
    }
}

