/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedXUtil {
    private static final Logger log = LoggerFactory.getLogger(FedXUtil.class);
    private static final AtomicLong count = new AtomicLong(0L);

    public static IRI iri(String iri) {
        return FedXUtil.valueFactory().createIRI(iri);
    }

    public static Literal literal(String literal) {
        return FedXUtil.valueFactory().createLiteral(literal);
    }

    public static ValueFactory valueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public static void applyQueryBindings(SailQuery query) {
        query.setBinding("__originalQueryMaxExecutionTime", FedXUtil.valueFactory().createLiteral(query.getMaxExecutionTime()));
    }

    public static String getIncrementalUUID() {
        long id = count.incrementAndGet();
        return Long.toHexString(id);
    }

    public static void applyMaxQueryExecutionTime(Operation operation, FederationContext federationContext) {
        int maxExecutionTime = federationContext.getConfig().getEnforceMaxQueryTime();
        if (maxExecutionTime <= 0) {
            return;
        }
        operation.setMaxExecutionTime(maxExecutionTime);
    }

    public static Dataset toDataset(Resource[] contexts) {
        SimpleDataset dataset = new SimpleDataset();
        for (Resource context : contexts) {
            if (!(context instanceof IRI)) {
                log.warn("FedX does not support to use non-IRIs as context identifier. Ignoring {}", (Object)context);
                continue;
            }
            dataset.addDefaultGraph((IRI)context);
        }
        return dataset;
    }

    public static Resource[] toContexts(Dataset ds) {
        if (ds == null) {
            return new Resource[0];
        }
        return ds.getDefaultGraphs().toArray(new Resource[0]);
    }

    public static Resource[] toContexts(StatementPattern stmt, Dataset dataset) {
        if (!(dataset != null || stmt.getContextVar() != null && stmt.getContextVar().hasValue())) {
            return new Resource[0];
        }
        HashSet contexts = Sets.newHashSet();
        if (dataset != null) {
            contexts.addAll(dataset.getDefaultGraphs());
        }
        if (stmt.getScope().equals((Object)StatementPattern.Scope.NAMED_CONTEXTS) && stmt.getContextVar().hasValue()) {
            contexts.add((Resource)stmt.getContextVar().getValue());
        }
        return contexts.toArray(new Resource[contexts.size()]);
    }

    public static Dataset toDataset(StatementPattern stmt, Dataset dataset) {
        Value stmtContext;
        if (stmt.getContextVar() == null || !stmt.getContextVar().hasValue()) {
            return dataset;
        }
        SimpleDataset res = new SimpleDataset();
        if (dataset != null) {
            dataset.getDefaultGraphs().forEach(iri -> res.addDefaultGraph((IRI)iri));
            dataset.getNamedGraphs().forEach(iri -> res.addNamedGraph((IRI)iri));
            dataset.getDefaultRemoveGraphs().forEach(iri -> res.addDefaultRemoveGraph((IRI)iri));
            res.setDefaultInsertGraph(dataset.getDefaultInsertGraph());
        }
        if ((stmtContext = stmt.getContextVar().getValue()) instanceof IRI) {
            res.addDefaultGraph((IRI)stmtContext);
        } else {
            log.warn("FedX named graph handling does not support non-IRIs: " + stmtContext);
        }
        return res;
    }
}

