/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;

public class DelayedEvaluationIteration
extends AbstractCloseableIteration<BindingSet, QueryEvaluationException> {
    private final QueryEvaluationStep arg;
    private final BindingSet bs;
    private CloseableIteration<BindingSet, QueryEvaluationException> iter;

    public DelayedEvaluationIteration(QueryEvaluationStep arg, BindingSet bs) {
        this.arg = arg;
        this.bs = bs;
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        return this.arg.evaluate(this.bs);
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        if (this.isClosed()) {
            return false;
        }
        this.initialise();
        return this.iter.hasNext();
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        this.initialise();
        return (BindingSet)this.iter.next();
    }

    private void initialise() throws QueryEvaluationException {
        if (this.iter == null) {
            this.iter = this.createIteration();
        }
    }

    @Override
    public void remove() throws QueryEvaluationException {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        if (this.iter == null) {
            throw new IllegalStateException("Underlying iteration was null");
        }
        this.iter.remove();
    }

    @Override
    protected final void handleClose() throws QueryEvaluationException {
        if (this.iter != null) {
            this.iter.close();
        }
    }
}

