/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.event.base;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;
import org.eclipse.rdf4j.repository.event.InterceptingRepository;
import org.eclipse.rdf4j.repository.event.InterceptingRepositoryConnection;
import org.eclipse.rdf4j.repository.event.RepositoryConnectionInterceptor;
import org.eclipse.rdf4j.repository.event.RepositoryInterceptor;
import org.eclipse.rdf4j.repository.event.base.InterceptingRepositoryConnectionWrapper;

public class InterceptingRepositoryWrapper
extends RepositoryWrapper
implements InterceptingRepository {
    private boolean activated;
    private final Set<RepositoryInterceptor> interceptors = new CopyOnWriteArraySet<RepositoryInterceptor>();
    private final Set<RepositoryConnectionInterceptor> conInterceptors = new CopyOnWriteArraySet<RepositoryConnectionInterceptor>();

    public InterceptingRepositoryWrapper() {
    }

    public InterceptingRepositoryWrapper(Repository delegate) {
        super(delegate);
    }

    @Override
    public void addRepositoryInterceptor(RepositoryInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.activated = true;
    }

    @Override
    public void removeRepositoryInterceptor(RepositoryInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.activated = !this.interceptors.isEmpty();
    }

    @Override
    public void addRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.conInterceptors.add(interceptor);
    }

    @Override
    public void removeRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.conInterceptors.remove(interceptor);
    }

    @Override
    public InterceptingRepositoryConnection getConnection() throws RepositoryException {
        RepositoryConnection conn = this.getDelegate().getConnection();
        if (this.activated) {
            RepositoryInterceptor interceptor;
            boolean denied = false;
            Iterator<Object> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).getConnection(this.getDelegate(), conn))) {
            }
            if (denied) {
                conn = null;
            }
        }
        if (conn == null) {
            return null;
        }
        InterceptingRepositoryConnectionWrapper iconn = new InterceptingRepositoryConnectionWrapper(this, conn);
        for (RepositoryConnectionInterceptor conInterceptor : this.conInterceptors) {
            iconn.addRepositoryConnectionInterceptor(conInterceptor);
        }
        return iconn;
    }

    @Override
    public void init() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryInterceptor interceptor;
            Iterator<RepositoryInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).init(this.getDelegate()))) {
            }
        }
        if (!denied) {
            this.getDelegate().init();
        }
    }

    @Override
    public void setDataDir(File dataDir) {
        boolean denied = false;
        if (this.activated) {
            RepositoryInterceptor interceptor;
            Iterator<RepositoryInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).setDataDir(this.getDelegate(), dataDir))) {
            }
        }
        if (!denied) {
            this.getDelegate().setDataDir(dataDir);
        }
    }

    @Override
    public void shutDown() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryInterceptor interceptor;
            Iterator<RepositoryInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).shutDown(this.getDelegate()))) {
            }
        }
        if (!denied) {
            this.getDelegate().shutDown();
        }
    }
}

