/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.trix;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;
import org.eclipse.rdf4j.common.xml.SimpleSAXAdapter;
import org.eclipse.rdf4j.common.xml.SimpleSAXParser;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.eclipse.rdf4j.rio.helpers.XMLReaderBasedParser;
import org.eclipse.rdf4j.rio.trix.TriXParserSettings;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TriXParser
extends XMLReaderBasedParser
implements ErrorHandler {
    private SimpleSAXParser saxParser;

    public TriXParser() {
        this(SimpleValueFactory.getInstance());
    }

    public TriXParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public final RDFFormat getRDFFormat() {
        return RDFFormat.TRIX;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet results = new HashSet(super.getSupportedSettings());
        results.addAll(this.getCompulsoryXmlPropertySettings());
        results.addAll(this.getCompulsoryXmlFeatureSettings());
        results.addAll(this.getOptionalXmlPropertySettings());
        results.addAll(this.getOptionalXmlFeatureSettings());
        results.add(XMLParserSettings.CUSTOM_XML_READER);
        results.add(XMLParserSettings.FAIL_ON_MISMATCHED_TAGS);
        results.add(XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS);
        results.add(TriXParserSettings.FAIL_ON_INVALID_STATEMENT);
        results.add(TriXParserSettings.FAIL_ON_MISSING_DATATYPE);
        return results;
    }

    @Override
    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be 'null'");
        }
        InputSource inputSource = new InputSource((InputStream)new BOMInputStream(in, false));
        if (baseURI != null) {
            inputSource.setSystemId(baseURI);
        }
        this.parse(inputSource);
    }

    @Override
    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be 'null'");
        }
        InputSource inputSource = new InputSource(reader);
        if (baseURI != null) {
            inputSource.setSystemId(baseURI);
        }
        this.parse(inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputSource inputStreamOrReader) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            if (this.rdfHandler != null) {
                this.rdfHandler.startRDF();
            }
            XMLReader xmlReader = this.getXMLReader();
            xmlReader.setErrorHandler(this);
            this.saxParser = new SimpleSAXParser(xmlReader);
            this.saxParser.setPreserveWhitespace(true);
            this.saxParser.setListener(new TriXSAXHandler());
            this.saxParser.parse(inputStreamOrReader);
        }
        catch (SAXParseException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc == null) {
                this.reportFatalError(e, (long)e.getLineNumber(), (long)e.getColumnNumber());
            } else {
                this.reportFatalError(wrappedExc, (long)e.getLineNumber(), (long)e.getColumnNumber());
            }
        }
        catch (SAXException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc == null) {
                this.reportFatalError(e);
            } else {
                if (wrappedExc instanceof RDFParseException) {
                    throw (RDFParseException)wrappedExc;
                }
                if (wrappedExc instanceof RDFHandlerException) {
                    throw (RDFHandlerException)wrappedExc;
                }
                this.reportFatalError(wrappedExc);
            }
        }
        finally {
            this.clear();
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    @Override
    protected Literal createLiteral(String label, String lang, IRI datatype) throws RDFParseException {
        Locator locator = this.saxParser.getLocator();
        if (locator != null) {
            return this.createLiteral(label, lang, datatype, locator.getLineNumber(), locator.getColumnNumber());
        }
        return this.createLiteral(label, lang, datatype, -1L, -1L);
    }

    @Override
    protected void reportWarning(String msg) {
        Locator locator = this.saxParser.getLocator();
        if (locator != null) {
            this.reportWarning(msg, locator.getLineNumber(), locator.getColumnNumber());
        } else {
            this.reportWarning(msg, -1L, -1L);
        }
    }

    @Override
    protected void reportError(String msg, RioSetting<Boolean> setting) throws RDFParseException {
        Locator locator = this.saxParser.getLocator();
        if (locator != null) {
            this.reportError(msg, (long)locator.getLineNumber(), (long)locator.getColumnNumber(), setting);
        } else {
            this.reportError(msg, -1L, -1L, setting);
        }
    }

    @Override
    protected void reportFatalError(String msg) throws RDFParseException {
        Locator locator = this.saxParser.getLocator();
        if (locator != null) {
            this.reportFatalError(msg, (long)locator.getLineNumber(), (long)locator.getColumnNumber());
        } else {
            this.reportFatalError(msg, -1L, -1L);
        }
    }

    @Override
    protected void reportFatalError(Exception e) throws RDFParseException {
        Locator locator = this.saxParser.getLocator();
        if (locator != null) {
            this.reportFatalError(e, (long)locator.getLineNumber(), (long)locator.getColumnNumber());
        } else {
            this.reportFatalError(e, -1L, -1L);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.reportWarning(exception.getMessage());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        try {
            this.reportError(exception.getMessage(), XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS);
        }
        catch (RDFParseException rdfpe) {
            throw new SAXException(rdfpe);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        try {
            this.reportFatalError(exception.getMessage());
        }
        catch (RDFParseException rdfpe) {
            throw new SAXException(rdfpe);
        }
    }

    private class TriXSAXHandler
    extends SimpleSAXAdapter {
        private Resource currentContext = null;
        private boolean parsingContext;
        private final List<Value> valueList = new ArrayList<Value>(3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
            block18: {
                try {
                    if (tagName.equals("uri")) {
                        this.valueList.add(TriXParser.this.createURI(text));
                        break block18;
                    }
                    if (tagName.equals("id")) {
                        this.valueList.add(TriXParser.this.createNode(text));
                        break block18;
                    }
                    if (tagName.equals("plainLiteral")) {
                        String lang = atts.get("xml:lang");
                        this.valueList.add(TriXParser.this.createLiteral(text, lang, null));
                        break block18;
                    }
                    if (tagName.equals("typedLiteral")) {
                        String datatype = atts.get("datatype");
                        if (datatype == null) {
                            TriXParser.this.reportError("datatype attribute missing for typed literal", TriXParserSettings.FAIL_ON_MISSING_DATATYPE);
                            this.valueList.add(TriXParser.this.createLiteral(text, null, null));
                        } else {
                            IRI dtURI = TriXParser.this.createURI(datatype);
                            this.valueList.add(TriXParser.this.createLiteral(text, null, dtURI));
                        }
                        break block18;
                    }
                    if (tagName.equals("triple")) {
                        if (!this.parsingContext) break block18;
                        try {
                            if (this.valueList.size() > 1) {
                                TriXParser.this.reportError("At most 1 resource can be specified for the context", TriXParserSettings.FAIL_ON_INVALID_STATEMENT);
                            } else if (this.valueList.size() == 1) {
                                try {
                                    this.currentContext = (Resource)this.valueList.get(0);
                                }
                                catch (ClassCastException e) {
                                    TriXParser.this.reportError("Context identifier should be a URI or blank node", TriXParserSettings.FAIL_ON_INVALID_STATEMENT);
                                }
                            }
                            break block18;
                        }
                        finally {
                            this.parsingContext = false;
                            this.valueList.clear();
                        }
                    }
                    if (tagName.equals("graph")) {
                        this.parsingContext = true;
                    }
                }
                catch (RDFParseException e) {
                    throw new SAXException(e);
                }
            }
        }

        @Override
        public void endTag(String tagName) throws SAXException {
            try {
                if (tagName.equals("triple")) {
                    this.reportStatement();
                } else if (tagName.equals("graph")) {
                    this.currentContext = null;
                }
            }
            catch (RDFHandlerException | RDFParseException e) {
                throw new SAXException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportStatement() throws RDFParseException, RDFHandlerException {
            try {
                IRI pred;
                Resource subj;
                if (this.valueList.size() != 3) {
                    TriXParser.this.reportError("exactly 3 values are required for a triple", TriXParserSettings.FAIL_ON_INVALID_STATEMENT);
                    return;
                }
                try {
                    subj = (Resource)this.valueList.get(0);
                }
                catch (ClassCastException e) {
                    TriXParser.this.reportError("First value for a triple should be a URI or blank node", TriXParserSettings.FAIL_ON_INVALID_STATEMENT);
                    this.valueList.clear();
                    return;
                }
                try {
                    pred = (IRI)this.valueList.get(1);
                }
                catch (ClassCastException e) {
                    TriXParser.this.reportError("Second value for a triple should be a URI", TriXParserSettings.FAIL_ON_INVALID_STATEMENT);
                    this.valueList.clear();
                    return;
                }
                Value obj = this.valueList.get(2);
                Statement st = TriXParser.this.createStatement(subj, pred, obj, this.currentContext);
                if (TriXParser.this.rdfHandler != null) {
                    TriXParser.this.rdfHandler.handleStatement(st);
                }
            }
            finally {
                this.valueList.clear();
            }
        }
    }
}

