/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.http.config.HTTPRepositorySchema;

public class HTTPRepositoryConfig
extends AbstractRepositoryImplConfig {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    private String url;
    private String username;
    private String password;

    public HTTPRepositoryConfig() {
        super("openrdf:HTTPRepository");
    }

    public HTTPRepositoryConfig(String url) {
        this();
        this.setURL(url);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.url == null) {
            throw new RepositoryConfigException("No URL specified for HTTP repository");
        }
    }

    @Override
    public Resource export(Model graph) {
        Resource implNode = super.export(graph);
        if (this.url != null) {
            graph.setNamespace("config", "tag:rdf4j.org,2023:config/");
            if (USE_CONFIG) {
                graph.add(implNode, CONFIG.Http.url, SimpleValueFactory.getInstance().createIRI(this.url), new Resource[0]);
            } else {
                graph.add(implNode, HTTPRepositorySchema.REPOSITORYURL, SimpleValueFactory.getInstance().createIRI(this.url), new Resource[0]);
            }
        }
        return implNode;
    }

    @Override
    public void parse(Model model, Resource implNode) throws RepositoryConfigException {
        super.parse(model, implNode);
        try {
            Configurations.getIRIValue(model, implNode, CONFIG.Http.url, HTTPRepositorySchema.REPOSITORYURL).ifPresent(iri -> this.setURL(iri.stringValue()));
            Configurations.getLiteralValue(model, implNode, CONFIG.Http.username, HTTPRepositorySchema.USERNAME).ifPresent(username -> this.setUsername(username.getLabel()));
            Configurations.getLiteralValue(model, implNode, CONFIG.Http.password, HTTPRepositorySchema.PASSWORD).ifPresent(password -> this.setPassword(password.getLabel()));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

