/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;

public class RepositoryConfig {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    private String id;
    private String title;
    private RepositoryImplConfig implConfig;

    public RepositoryConfig() {
    }

    public RepositoryConfig(String id) {
        this();
        this.setID(id);
    }

    public RepositoryConfig(String id, RepositoryImplConfig implConfig) {
        this(id);
        this.setRepositoryImplConfig(implConfig);
    }

    public RepositoryConfig(String id, String title) {
        this(id);
        this.setTitle(title);
    }

    public RepositoryConfig(String id, String title, RepositoryImplConfig implConfig) {
        this(id, title);
        this.setRepositoryImplConfig(implConfig);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public RepositoryImplConfig getRepositoryImplConfig() {
        return this.implConfig;
    }

    public void setRepositoryImplConfig(RepositoryImplConfig implConfig) {
        this.implConfig = implConfig;
    }

    public void validate() throws RepositoryConfigException {
        if (this.id == null) {
            throw new RepositoryConfigException("Repository ID missing");
        }
        if (this.implConfig == null) {
            throw new RepositoryConfigException("Repository implementation for repository missing");
        }
        this.implConfig.validate();
    }

    @Deprecated
    public void export(Model model) {
        this.export(model, Values.bnode());
    }

    public void export(Model model, Resource repositoryNode) {
        model.setNamespace(RDFS.NS);
        model.setNamespace(XSD.NS);
        model.setNamespace(CONFIG.NS);
        model.add(repositoryNode, RDF.TYPE, CONFIG.Rep.Repository, new Resource[0]);
        model.add(repositoryNode, RDF.TYPE, RepositoryConfigSchema.REPOSITORY, new Resource[0]);
        if (this.id != null) {
            if (USE_CONFIG) {
                model.add(repositoryNode, CONFIG.Rep.id, Values.literal(this.id), new Resource[0]);
            } else {
                model.add(repositoryNode, RepositoryConfigSchema.REPOSITORYID, Values.literal(this.id), new Resource[0]);
            }
        }
        if (this.title != null) {
            model.add(repositoryNode, RDFS.LABEL, Values.literal(this.title), new Resource[0]);
        }
        if (this.implConfig != null) {
            Resource implNode = this.implConfig.export(model);
            if (USE_CONFIG) {
                model.add(repositoryNode, CONFIG.Rep.impl, implNode, new Resource[0]);
            } else {
                model.add(repositoryNode, RepositoryConfigSchema.REPOSITORYIMPL, implNode, new Resource[0]);
            }
        }
    }

    public void parse(Model model, Resource repositoryNode) throws RepositoryConfigException {
        try {
            Configurations.getLiteralValue(model, repositoryNode, CONFIG.Rep.id, RepositoryConfigSchema.REPOSITORYID).ifPresent(lit -> this.setID(lit.getLabel()));
            Models.objectLiteral(model.getStatements(repositoryNode, RDFS.LABEL, null, new Resource[0])).ifPresent(lit -> this.setTitle(lit.getLabel()));
            Configurations.getResourceValue(model, repositoryNode, CONFIG.Rep.impl, RepositoryConfigSchema.REPOSITORYIMPL).ifPresent(res -> this.setRepositoryImplConfig(AbstractRepositoryImplConfig.create(model, res)));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }

    public static RepositoryConfig create(Model model, Resource repositoryNode) throws RepositoryConfigException {
        RepositoryConfig config = new RepositoryConfig();
        config.parse(model, repositoryNode);
        return config;
    }
}

