/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.explanation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.annotation.Experimental;

@Experimental
public class GenericPlanNode {
    public static final String UNKNOWN = "UNKNOWN";
    private static final String uniqueIdPrefix = UUID.randomUUID().toString().replace("-", "");
    private static final AtomicLong uniqueIdSuffix = new AtomicLong();
    private static final String newLine = System.getProperty("line.separator");
    private final String id = "UUID_" + uniqueIdPrefix + uniqueIdSuffix.incrementAndGet();
    private String type;
    private Boolean timedOut;
    private Double costEstimate;
    private Double resultSizeEstimate;
    private Long resultSizeActual;
    private Double totalTimeActual;
    private Boolean newScope;
    private String algorithm;
    private List<GenericPlanNode> plans = new ArrayList<GenericPlanNode>();
    private static int prettyBoxDrawingType = 0;

    public GenericPlanNode() {
    }

    public GenericPlanNode(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<GenericPlanNode> getPlans() {
        return this.plans.isEmpty() ? null : this.plans;
    }

    public void setPlans(List<GenericPlanNode> plans) {
        this.plans = plans;
    }

    public void addPlans(GenericPlanNode ... children) {
        this.plans.addAll(Arrays.asList(children));
    }

    public Double getCostEstimate() {
        return this.costEstimate;
    }

    public void setCostEstimate(Double costEstimate) {
        if (costEstimate >= 0.0) {
            this.costEstimate = costEstimate;
        }
    }

    public Double getResultSizeEstimate() {
        return this.resultSizeEstimate;
    }

    public void setResultSizeEstimate(Double resultSizeEstimate) {
        if (resultSizeEstimate >= 0.0) {
            this.resultSizeEstimate = resultSizeEstimate;
        }
    }

    public Long getResultSizeActual() {
        return this.resultSizeActual;
    }

    public void setResultSizeActual(Long resultSizeActual) {
        if (resultSizeActual >= 0L) {
            this.resultSizeActual = resultSizeActual;
        }
    }

    public Double getTotalTimeActual() {
        double sum;
        if (this.totalTimeActual == null && (sum = this.plans.stream().map(GenericPlanNode::getTotalTimeActual).filter(Objects::nonNull).mapToDouble(d -> d).sum()) > 0.0) {
            return sum;
        }
        return this.totalTimeActual;
    }

    public void setTotalTimeActual(Double totalTimeActual) {
        if (totalTimeActual >= 0.0) {
            this.totalTimeActual = totalTimeActual;
        }
    }

    public void setTimedOut(Boolean timedOut) {
        this.timedOut = timedOut;
    }

    public Boolean getTimedOut() {
        return this.timedOut;
    }

    public Double getSelfTimeActual() {
        if (this.totalTimeActual == null) {
            return null;
        }
        double childTime = this.plans.stream().map(GenericPlanNode::getTotalTimeActual).filter(Objects::nonNull).mapToDouble(t -> t).sum();
        return this.totalTimeActual - childTime;
    }

    public Boolean isNewScope() {
        return this.newScope;
    }

    public void setNewScope(boolean newScope) {
        this.newScope = newScope ? Boolean.valueOf(true) : null;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        return this.getHumanReadable(0);
    }

    private String getHumanReadable(int prettyBoxDrawingType) {
        StringBuilder sb = new StringBuilder();
        if (this.timedOut != null && this.timedOut.booleanValue()) {
            sb.append("Timed out while retrieving explanation! Explanation may be incomplete!").append(newLine);
            sb.append("You can change the timeout by setting .setMaxExecutionTime(...) on your query.").append(newLine).append(newLine);
        }
        sb.append(this.type);
        if (this.newScope != null && this.newScope.booleanValue()) {
            sb.append(" (new scope)");
        }
        if (this.algorithm != null) {
            sb.append(" (").append(this.algorithm).append(")");
        }
        this.appendCostAnnotation(sb);
        sb.append(newLine);
        if (this.plans.size() == 2 && this.plans.stream().anyMatch(p -> !p.plans.isEmpty())) {
            int i;
            String end;
            String vertical;
            String horizontal;
            String start;
            if (prettyBoxDrawingType % 2 == 0) {
                start = "\u2560";
                horizontal = "\u2550\u2550";
                vertical = "\u2551";
                end = "\u255a";
            } else {
                start = "\u251c";
                horizontal = "\u2500\u2500";
                vertical = "\u2502";
                end = "\u2514";
            }
            String left = this.plans.get(0).getHumanReadable(prettyBoxDrawingType + 1);
            String right = this.plans.get(1).getHumanReadable(prettyBoxDrawingType + 1);
            String[] split = left.split(newLine);
            sb.append(start).append(horizontal).append(split[0]).append(newLine);
            for (i = 1; i < split.length; ++i) {
                sb.append(vertical).append("  ").append(split[i]).append(newLine);
            }
            split = right.split(newLine);
            sb.append(end).append(horizontal).append(split[0]).append(newLine);
            for (i = 1; i < split.length; ++i) {
                sb.append("   ").append(split[i]).append(newLine);
            }
        } else {
            this.plans.forEach(child -> sb.append(Arrays.stream(child.getHumanReadable(prettyBoxDrawingType + 1).split(newLine)).map(c -> "   " + c).reduce((a, b) -> a + newLine + b).orElse("") + newLine));
        }
        return sb.toString();
    }

    private static String toHumanReadableNumber(Double number) {
        Object humanReadbleString = number == null ? UNKNOWN : (number == Double.POSITIVE_INFINITY ? "\u221e" : (number > 1000000.0 ? (double)Math.round(number / 100000.0) / 10.0 + "M" : (number > 1000.0 ? (double)Math.round(number / 100.0) / 10.0 + "K" : (number >= 0.0 ? "" + Math.round(number) : UNKNOWN))));
        return humanReadbleString;
    }

    private static String toHumanReadableNumber(Long number) {
        Object humanReadbleString = number == null ? UNKNOWN : ((double)number.longValue() == Double.POSITIVE_INFINITY ? "\u221e" : (number > 1000000L ? (double)(number / 100000L) / 10.0 + "M" : (number > 1000L ? (double)(number / 100L) / 10.0 + "K" : (number >= 0L ? "" + number : UNKNOWN))));
        return humanReadbleString;
    }

    private static String toHumanReadableTime(Double millis) {
        Object humanReadbleString = millis == null ? UNKNOWN : (millis > 1000.0 ? (double)Math.round(millis / 100.0) / 10.0 + "s" : (millis >= 100.0 ? Math.round(millis) + "ms" : (millis >= 10.0 ? (double)Math.round(millis * 10.0) / 10.0 + "ms" : (millis >= 1.0 ? (double)Math.round(millis * 100.0) / 100.0 + "ms" : (millis >= 0.0 ? (double)Math.round(millis * 1000.0) / 1000.0 + "ms" : UNKNOWN)))));
        return humanReadbleString;
    }

    private void appendCostAnnotation(StringBuilder sb) {
        String costs = Stream.of("costEstimate=" + GenericPlanNode.toHumanReadableNumber(this.getCostEstimate()), "resultSizeEstimate=" + GenericPlanNode.toHumanReadableNumber(this.getResultSizeEstimate()), "resultSizeActual=" + GenericPlanNode.toHumanReadableNumber(this.getResultSizeActual()), "totalTimeActual=" + GenericPlanNode.toHumanReadableTime(this.getTotalTimeActual()), "selfTimeActual=" + GenericPlanNode.toHumanReadableTime(this.getSelfTimeActual())).filter(s -> !s.endsWith(UNKNOWN)).reduce((a, b) -> a + ", " + b).orElse("");
        if (!costs.isEmpty()) {
            sb.append(" (").append(costs).append(")");
        }
    }

    public String toDot() {
        return this.toDotInternal(GenericPlanNode.getMaxResultSizeActual(this), GenericPlanNode.getMaxTotalTime(this), GenericPlanNode.getMaxSelfTime(this));
    }

    private static double getMaxTotalTime(GenericPlanNode genericPlanNode) {
        return Math.max(genericPlanNode.getTotalTimeActual() != null ? genericPlanNode.getTotalTimeActual() : 0.0, genericPlanNode.plans.stream().mapToDouble(GenericPlanNode::getMaxTotalTime).max().orElse(0.0));
    }

    private static double getMaxSelfTime(GenericPlanNode genericPlanNode) {
        return Math.max(genericPlanNode.getSelfTimeActual() != null ? genericPlanNode.getSelfTimeActual() : 0.0, genericPlanNode.plans.stream().mapToDouble(GenericPlanNode::getMaxSelfTime).max().orElse(0.0));
    }

    private static double getMaxResultSizeActual(GenericPlanNode genericPlanNode) {
        return Math.max(genericPlanNode.getResultSizeActual() != null ? (double)genericPlanNode.getResultSizeActual().longValue() : 0.0, genericPlanNode.plans.stream().mapToDouble(GenericPlanNode::getMaxResultSizeActual).max().orElse(0.0));
    }

    private String toDotInternal(double maxResultSizeActual, double maxTotalTime, double maxSelfTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("   ");
        if (this.newScope != null && this.newScope.booleanValue()) {
            sb.append("subgraph cluster_").append(this.getID()).append(" {").append(newLine).append("   color=grey").append(newLine);
        }
        String resultSizeActualColor = this.getProportionalRedColor((Double)maxResultSizeActual, this.getResultSizeActual());
        String totalTimeColor = this.getProportionalRedColor((Double)maxTotalTime, this.getTotalTimeActual());
        String selfTimeColor = this.getProportionalRedColor((Double)maxSelfTime, this.getSelfTimeActual());
        sb.append(this.getID()).append(" [label=").append("<<table BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"3\" >");
        sb.append(Stream.of("<tr><td COLSPAN=\"2\" BGCOLOR=\"" + totalTimeColor + "\"><U>" + StringEscapeUtils.escapeHtml4((String)this.type) + "</U></td></tr>", "<tr><td>Algorithm</td><td>" + (this.algorithm != null ? this.algorithm : UNKNOWN) + "</td></tr>", "<tr><td><B>New scope</B></td><td>" + (this.newScope != null && this.newScope != false ? "<B>true</B>" : UNKNOWN) + "</td></tr>", "<tr><td>Cost estimate</td><td>" + GenericPlanNode.toHumanReadableNumber(this.getCostEstimate()) + "</td></tr>", "<tr><td>Result size estimate</td><td>" + GenericPlanNode.toHumanReadableNumber(this.getResultSizeEstimate()) + "</td></tr>", "<tr><td >Result size actual</td><td>" + GenericPlanNode.toHumanReadableNumber(this.getResultSizeActual()) + "</td></tr>", "<tr><td >Total time actual</td><td BGCOLOR=\"" + totalTimeColor + "\">" + GenericPlanNode.toHumanReadableTime(this.getTotalTimeActual()) + "</td></tr>", "<tr><td >Self time actual</td><td BGCOLOR=\"" + selfTimeColor + "\">" + GenericPlanNode.toHumanReadableTime(this.getSelfTimeActual()) + "</td></tr>").filter(s -> !s.contains(UNKNOWN)).reduce((a, b) -> a + " " + b).orElse(""));
        sb.append("</table>>").append(" shape=plaintext];").append(newLine);
        for (int i = 0; i < this.plans.size(); ++i) {
            GenericPlanNode p2 = this.plans.get(i);
            Object linkLabel = "index " + i;
            if (this.plans.size() == 2) {
                linkLabel = i == 0 ? "left" : "right";
            } else if (this.plans.size() == 1) {
                linkLabel = "";
            }
            sb.append("   ").append(this.getID()).append(" -> ").append(p2.getID()).append(" [label=\"").append((String)linkLabel).append("\"]").append(" ;").append(newLine);
        }
        this.plans.forEach(p -> sb.append(p.toDotInternal(maxResultSizeActual, maxTotalTime, maxSelfTime)));
        if (this.newScope != null && this.newScope.booleanValue()) {
            sb.append(newLine).append("}").append(newLine);
        }
        return sb.toString();
    }

    private String getProportionalRedColor(Double max, Double value) {
        Object mainColor = "#FFFFFF";
        if (value != null) {
            double colorInt = Math.abs(256.0 / max * value - 256.0);
            String hexColor = String.format("%02X", 0xFFFFFF & (int)Math.floor(colorInt));
            mainColor = "#FF" + hexColor + hexColor;
        }
        return mainColor;
    }

    private String getProportionalRedColor(Double max, Long value) {
        if (value != null) {
            return this.getProportionalRedColor(max, (double)value.longValue() + 0.0);
        }
        return "#FFFFFF";
    }

    @JsonIgnore
    public String getID() {
        return this.id;
    }
}

