/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class ProjectionRemovalOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new ProjectionFinder());
    }

    private class ProjectionFinder
    extends AbstractQueryModelVisitor<RuntimeException> {
        private ProjectionFinder() {
        }

        public void meet(Projection node) throws RuntimeException {
            super.meet(node);
            VariableFinder findVariables = new VariableFinder();
            node.visit((QueryModelVisitor)findVariables);
            Set foundChildVariableNames = findVariables.getVars().stream().map(Var::getName).collect(Collectors.toSet());
            if (foundChildVariableNames.equals(node.getBindingNames())) {
                TupleExpr child = node.getArg();
                node.getParentNode().replaceChildNode((QueryModelNode)node, (QueryModelNode)child);
            }
        }
    }

    private class VariableFinder
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final Set<Var> vars = new HashSet<Var>();

        private VariableFinder() {
        }

        public void meet(Var node) throws RuntimeException {
            this.vars.add(node);
            super.meet(node);
        }

        public Set<Var> getVars() {
            return this.vars;
        }
    }
}

