/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class Ceil
implements Function {
    @Override
    public String getURI() {
        return FN.NUMERIC_CEIL.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("CEIL requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            IRI datatype = literal.getDatatype();
            if (datatype != null && XMLDatatypeUtil.isNumericDatatype((IRI)datatype)) {
                if (XMLDatatypeUtil.isIntegerDatatype((IRI)datatype)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isDecimalDatatype((IRI)datatype)) {
                    BigDecimal ceilingValue = literal.decimalValue().setScale(0, RoundingMode.CEILING);
                    return valueFactory.createLiteral(ceilingValue.toPlainString(), datatype);
                }
                if (XMLDatatypeUtil.isFloatingPointDatatype((IRI)datatype)) {
                    double ceilingValue = Math.ceil(literal.doubleValue());
                    return valueFactory.createLiteral(Double.toString(ceilingValue), datatype);
                }
                throw new ValueExprEvaluationException("unexpected datatype for function operand: " + args[0]);
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

