/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;

public abstract class LogicalOperatorConstraintComponent
extends AbstractConstraintComponent {
    public LogicalOperatorConstraintComponent(Resource id) {
        super(id);
    }

    static SparqlFragment buildSparqlValidNodes_rsx_targetShape_inner(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, List<Shape> shapes, TargetChain targetChain, Function<List<SparqlFragment>, SparqlFragment> bgpCombiner, Function<List<SparqlFragment>, SparqlFragment> filterCombiner) {
        List<SparqlFragment> sparqlFragments = shapes.stream().map(shape -> shape.buildSparqlValidNodes_rsx_targetShape(subject, object, rdfsSubClassOfReasoner, scope, stableRandomVariableProvider)).collect(Collectors.toList());
        if (scope == ConstraintComponent.Scope.nodeShape) {
            if (!SparqlFragment.isFilterCondition(sparqlFragments)) {
                return bgpCombiner.apply(sparqlFragments);
            }
            return filterCombiner.apply(sparqlFragments);
        }
        if (scope == ConstraintComponent.Scope.propertyShape) {
            if (!SparqlFragment.isFilterCondition(sparqlFragments)) {
                throw new UnsupportedOperationException();
            }
            assert (targetChain.getPath().isPresent());
            Path path = targetChain.getPath().get();
            StatementMatcher.Variable filterNotExistsVariable = stableRandomVariableProvider.next();
            SparqlFragment filterCondition = filterCombiner.apply(shapes.stream().map(c -> c.buildSparqlValidNodes_rsx_targetShape(subject, filterNotExistsVariable, rdfsSubClassOfReasoner, scope, stableRandomVariableProvider)).collect(Collectors.toList()));
            String pathQuery1 = path.getTargetQueryFragment(subject, object, rdfsSubClassOfReasoner, stableRandomVariableProvider);
            String pathQuery2 = path.getTargetQueryFragment(subject, filterNotExistsVariable, rdfsSubClassOfReasoner, stableRandomVariableProvider);
            String pathQuery3 = path.getTargetQueryFragment(subject, stableRandomVariableProvider.next(), rdfsSubClassOfReasoner, stableRandomVariableProvider);
            String unionCondition1 = String.join((CharSequence)"\n", "", pathQuery1, "FILTER ( NOT EXISTS {", SparqlFragment.indent(pathQuery2), "\tFILTER(!(" + filterCondition.getFragment() + "))", "})");
            String unionCondition2 = "\t " + subject.asSparqlVariable() + " " + stableRandomVariableProvider.next().asSparqlVariable() + " " + stableRandomVariableProvider.next().asSparqlVariable() + ".\n\t FILTER(NOT EXISTS {\n " + SparqlFragment.indent(pathQuery3) + " \n})\n";
            String unionCondition3 = "\t " + stableRandomVariableProvider.next().asSparqlVariable() + " " + stableRandomVariableProvider.next().asSparqlVariable() + " " + subject.asSparqlVariable() + ".\n\t FILTER(NOT EXISTS {\n " + SparqlFragment.indent(pathQuery3) + " \n})\n";
            List<StatementMatcher> statementMatchers = SparqlFragment.getStatementMatchers(sparqlFragments);
            statementMatchers.add(new StatementMatcher(subject, null, null));
            statementMatchers.add(new StatementMatcher(null, null, subject));
            SparqlFragment sparqlFragment = SparqlFragment.union(unionCondition1, unionCondition2, unionCondition3);
            sparqlFragment.addStatementMatchers(statementMatchers);
            return sparqlFragment;
        }
        throw new UnsupportedOperationException("Unknown scope: " + scope);
    }
}

