/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnectionWrapper;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCachingRDFSInferencerConnection
extends InferencerConnectionWrapper
implements SailConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(SchemaCachingRDFSInferencerConnection.class);
    private final SchemaCachingRDFSInferencer sail;
    private final NotifyingSailConnection connection;
    private boolean statementsRemoved;
    private boolean statementsAdded;
    private final List<IRI> schemaPredicates = Arrays.asList(RDFS.SUBCLASSOF, RDFS.SUBPROPERTYOF, RDFS.RANGE, RDFS.DOMAIN, RDF.TYPE);
    private boolean schemaChange;
    private boolean inferredCleared = false;
    private long originalSchemaSize = -1L;

    SchemaCachingRDFSInferencerConnection(SchemaCachingRDFSInferencer sail, InferencerConnection connection) {
        super(connection);
        connection.addConnectionListener(this);
        this.sail = sail;
        this.connection = connection;
    }

    void processForSchemaCache(Statement statement) {
        this.sail.acquireExclusiveWriteLock();
        IRI predicate = statement.getPredicate();
        Value object = statement.getObject();
        Resource subject = statement.getSubject();
        if (predicate.equals(RDFS.SUBCLASSOF)) {
            this.sail.addSubClassOfStatement(statement);
            this.schemaChange = true;
        } else if (predicate.equals(RDF.TYPE) && object.equals(RDF.PROPERTY)) {
            this.sail.addProperty(subject);
            this.schemaChange = true;
        } else if (predicate.equals(RDFS.SUBPROPERTYOF)) {
            this.sail.addSubPropertyOfStatement(statement);
            this.schemaChange = true;
        } else if (predicate.equals(RDFS.RANGE)) {
            this.sail.addRangeStatement(statement);
            this.schemaChange = true;
        } else if (predicate.equals(RDFS.DOMAIN)) {
            this.sail.addDomainStatement(statement);
            this.schemaChange = true;
        } else if (predicate.equals(RDF.TYPE) && object.equals(RDFS.CLASS)) {
            this.sail.addSubClassOfStatement(this.sail.getValueFactory().createStatement(subject, RDFS.SUBCLASSOF, RDFS.RESOURCE));
            this.schemaChange = true;
        } else if (predicate.equals(RDF.TYPE) && object.equals(RDFS.DATATYPE)) {
            this.sail.addSubClassOfStatement(this.sail.getValueFactory().createStatement(subject, RDFS.SUBCLASSOF, RDFS.LITERAL));
            this.schemaChange = true;
        } else if (predicate.equals(RDF.TYPE) && object.equals(RDFS.CONTAINERMEMBERSHIPPROPERTY)) {
            this.sail.addSubPropertyOfStatement(this.sail.getValueFactory().createStatement(subject, RDFS.SUBPROPERTYOF, RDFS.MEMBER));
            this.schemaChange = true;
        } else if (predicate.equals(RDF.TYPE) && !this.sail.hasType((Resource)object)) {
            this.sail.addType((Resource)object);
            this.schemaChange = true;
        }
        if (!this.sail.hasProperty(predicate)) {
            this.sail.addProperty(predicate);
            this.schemaChange = true;
        }
    }

    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.inferredCleared = true;
    }

    @Override
    public void commit() throws SailException {
        super.commit();
        this.statementsRemoved = false;
        this.statementsAdded = false;
        this.schemaChange = false;
        this.sail.releaseExclusiveWriteLock();
    }

    void doInferencing() throws SailException {
        if (!this.sail.usesPredefinedSchema() && this.schemaChange) {
            this.regenerateCacheAndInferenceMaps(true);
            this.inferredCleared = true;
        }
        if (!this.inferredCleared) {
            return;
        }
        try (CloseableIteration<? extends Statement, SailException> statements = this.connection.getStatements(null, null, null, false, new Resource[0]);){
            while (statements.hasNext()) {
                Statement next = (Statement)statements.next();
                this.addStatement(false, next.getSubject(), next.getPredicate(), next.getObject(), next.getContext());
            }
        }
        this.inferredCleared = false;
    }

    private void regenerateCacheAndInferenceMaps(boolean addInferredStatements) {
        this.sail.clearInferenceTables();
        if (addInferredStatements) {
            this.addAxiomStatements();
        }
        try (CloseableIteration<? extends Statement, SailException> statements = this.connection.getStatements(null, null, null, this.sail.useInferredToCreateSchema, new Resource[0]);){
            while (statements.hasNext()) {
                Statement next = (Statement)statements.next();
                this.processForSchemaCache(this.sail.getValueFactory().createStatement(next.getSubject(), next.getPredicate(), next.getObject()));
            }
        }
        this.sail.calculateInferenceMaps(this, addInferredStatements);
        this.originalSchemaSize = this.sail.getSchemaSize();
    }

    boolean addInferredStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        return super.addInferredStatement(subj, pred, obj, contexts);
    }

    @Override
    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sail.useInferredToCreateSchema = true;
        this.addStatement(false, subj, pred, obj, contexts);
        return super.addInferredStatement(subj, pred, obj, contexts);
    }

    @Override
    public void addStatement(Resource subject, IRI predicate, Value object, Resource ... contexts) throws SailException {
        this.addStatement(true, subject, predicate, object, contexts);
    }

    private void addStatement(boolean actuallyAdd, Resource subject, IRI predicate, Value object, Resource ... context) throws SailException {
        Resource[] inferredContext = this.sail.isAddInferredStatementsToDefaultContext() ? new Resource[]{} : context;
        this.sail.acquireExclusiveWriteLock();
        if (!this.sail.usesPredefinedSchema()) {
            this.processForSchemaCache(this.sail.getValueFactory().createStatement(subject, predicate, object));
        }
        if (this.sail.useAllRdfsRules) {
            this.addInferredStatementInternal(subject, RDF.TYPE, RDFS.RESOURCE, inferredContext);
            if (object instanceof Resource) {
                this.addInferredStatementInternal((Resource)object, RDF.TYPE, RDFS.RESOURCE, inferredContext);
            }
        }
        if (predicate.getNamespace().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && predicate.getLocalName().charAt(0) == '_') {
            try {
                int i = Integer.parseInt(predicate.getLocalName().substring(1));
                if (i >= 1) {
                    this.addInferredStatementInternal(subject, RDFS.MEMBER, object, inferredContext);
                    this.addInferredStatementInternal(predicate, RDF.TYPE, RDFS.RESOURCE, inferredContext);
                    this.addInferredStatementInternal(predicate, RDF.TYPE, RDFS.CONTAINERMEMBERSHIPPROPERTY, inferredContext);
                    this.addInferredStatementInternal(predicate, RDF.TYPE, RDF.PROPERTY, inferredContext);
                    this.addInferredStatementInternal(predicate, RDFS.SUBPROPERTYOF, predicate, inferredContext);
                    this.addInferredStatementInternal(predicate, RDFS.SUBPROPERTYOF, RDFS.MEMBER, inferredContext);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (actuallyAdd) {
            this.connection.addStatement(subject, predicate, object, context);
        }
        if (predicate.equals(RDF.TYPE)) {
            if (!(object instanceof Resource)) {
                throw new SailException("Expected object to a a Resource: " + object.toString());
            }
            this.sail.resolveTypes((Resource)object).stream().peek(inferredType -> {
                if (this.sail.useAllRdfsRules && inferredType.equals(RDFS.CLASS)) {
                    this.addInferredStatementInternal(subject, RDFS.SUBCLASSOF, RDFS.RESOURCE, inferredContext);
                }
            }).filter(inferredType -> !inferredType.equals(object)).forEach(inferredType -> this.addInferredStatementInternal(subject, RDF.TYPE, (Value)inferredType, inferredContext));
        }
        this.sail.resolveProperties(predicate).stream().filter(inferredProperty -> !inferredProperty.equals(predicate)).filter(inferredPropery -> inferredPropery instanceof IRI).map(inferredPropery -> (IRI)inferredPropery).forEach(inferredProperty -> this.addInferredStatementInternal(subject, (IRI)inferredProperty, object, inferredContext));
        if (object instanceof Resource) {
            this.sail.resolveRangeTypes(predicate).stream().peek(inferredType -> {
                if (this.sail.useAllRdfsRules && inferredType.equals(RDFS.CLASS)) {
                    this.addInferredStatementInternal((Resource)object, RDFS.SUBCLASSOF, RDFS.RESOURCE, inferredContext);
                }
            }).forEach(inferredType -> this.addInferredStatementInternal((Resource)object, RDF.TYPE, (Value)inferredType, inferredContext));
        }
        this.sail.resolveDomainTypes(predicate).stream().peek(inferredType -> {
            if (this.sail.useAllRdfsRules && inferredType.equals(RDFS.CLASS)) {
                this.addInferredStatementInternal(subject, RDFS.SUBCLASSOF, RDFS.RESOURCE, inferredContext);
            }
        }).forEach(inferredType -> this.addInferredStatementInternal(subject, RDF.TYPE, (Value)inferredType, inferredContext));
    }

    void addAxiomStatements() {
        this.sail.acquireExclusiveWriteLock();
        ValueFactory vf = this.sail.getValueFactory();
        Statement statement = vf.createStatement(RDF.ALT, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.ALT, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.ALT, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.ALT, RDFS.SUBCLASSOF, RDFS.CONTAINER);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.ALT, RDFS.SUBCLASSOF, RDF.ALT);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.BAG, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.BAG, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.BAG, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.BAG, RDFS.SUBCLASSOF, RDFS.CONTAINER);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.BAG, RDFS.SUBCLASSOF, RDF.BAG);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.LIST, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.LIST, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.LIST, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.LIST, RDFS.SUBCLASSOF, RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PROPERTY, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PROPERTY, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PROPERTY, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PROPERTY, RDFS.SUBCLASSOF, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SEQ, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SEQ, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SEQ, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SEQ, RDFS.SUBCLASSOF, RDFS.CONTAINER);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SEQ, RDFS.SUBCLASSOF, RDF.SEQ);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.STATEMENT, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.STATEMENT, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.STATEMENT, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.STATEMENT, RDFS.SUBCLASSOF, RDF.STATEMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.XMLLITERAL, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.XMLLITERAL, RDF.TYPE, RDFS.DATATYPE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.XMLLITERAL, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.XMLLITERAL, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.XMLLITERAL, RDFS.SUBCLASSOF, RDFS.LITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.XMLLITERAL, RDFS.SUBCLASSOF, RDF.XMLLITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.FIRST, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.FIRST, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.FIRST, RDFS.DOMAIN, RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.FIRST, RDFS.RANGE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.FIRST, RDFS.SUBPROPERTYOF, RDF.FIRST);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.NIL, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.NIL, RDF.TYPE, RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.OBJECT, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.OBJECT, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.OBJECT, RDFS.DOMAIN, RDF.STATEMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.OBJECT, RDFS.RANGE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.OBJECT, RDFS.SUBPROPERTYOF, RDF.OBJECT);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PREDICATE, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PREDICATE, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PREDICATE, RDFS.DOMAIN, RDF.STATEMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PREDICATE, RDFS.RANGE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.PREDICATE, RDFS.SUBPROPERTYOF, RDF.PREDICATE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.REST, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.REST, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.REST, RDFS.DOMAIN, RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.REST, RDFS.RANGE, RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.REST, RDFS.SUBPROPERTYOF, RDF.REST);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SUBJECT, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SUBJECT, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SUBJECT, RDFS.DOMAIN, RDF.STATEMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SUBJECT, RDFS.RANGE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.SUBJECT, RDFS.SUBPROPERTYOF, RDF.SUBJECT);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.TYPE, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.TYPE, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.TYPE, RDFS.DOMAIN, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.TYPE, RDFS.RANGE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.TYPE, RDFS.SUBPROPERTYOF, RDF.TYPE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.VALUE, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.VALUE, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.VALUE, RDFS.DOMAIN, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.VALUE, RDFS.RANGE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDF.VALUE, RDFS.SUBPROPERTYOF, RDF.VALUE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CLASS, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CLASS, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CLASS, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CLASS, RDFS.SUBCLASSOF, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINER, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINER, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINER, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINER, RDFS.SUBCLASSOF, RDFS.CONTAINER);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINERMEMBERSHIPPROPERTY, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINERMEMBERSHIPPROPERTY, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINERMEMBERSHIPPROPERTY, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINERMEMBERSHIPPROPERTY, RDFS.SUBCLASSOF, RDFS.CONTAINERMEMBERSHIPPROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.CONTAINERMEMBERSHIPPROPERTY, RDFS.SUBCLASSOF, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DATATYPE, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DATATYPE, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DATATYPE, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DATATYPE, RDFS.SUBCLASSOF, RDFS.DATATYPE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DATATYPE, RDFS.SUBCLASSOF, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LITERAL, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LITERAL, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LITERAL, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LITERAL, RDFS.SUBCLASSOF, RDFS.LITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.RESOURCE, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.RESOURCE, RDF.TYPE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.RESOURCE, RDFS.SUBCLASSOF, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.COMMENT, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.COMMENT, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.COMMENT, RDFS.DOMAIN, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.COMMENT, RDFS.RANGE, RDFS.LITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.COMMENT, RDFS.SUBPROPERTYOF, RDFS.COMMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DOMAIN, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DOMAIN, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DOMAIN, RDFS.DOMAIN, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DOMAIN, RDFS.RANGE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.DOMAIN, RDFS.SUBPROPERTYOF, RDFS.DOMAIN);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.ISDEFINEDBY, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.ISDEFINEDBY, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.ISDEFINEDBY, RDFS.DOMAIN, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.ISDEFINEDBY, RDFS.RANGE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.ISDEFINEDBY, RDFS.SUBPROPERTYOF, RDFS.SEEALSO);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.ISDEFINEDBY, RDFS.SUBPROPERTYOF, RDFS.ISDEFINEDBY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LABEL, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LABEL, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LABEL, RDFS.DOMAIN, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LABEL, RDFS.RANGE, RDFS.LITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.LABEL, RDFS.SUBPROPERTYOF, RDFS.LABEL);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.MEMBER, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.MEMBER, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.MEMBER, RDFS.DOMAIN, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.MEMBER, RDFS.RANGE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.MEMBER, RDFS.SUBPROPERTYOF, RDFS.MEMBER);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.RANGE, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.RANGE, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.RANGE, RDFS.DOMAIN, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.RANGE, RDFS.RANGE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.RANGE, RDFS.SUBPROPERTYOF, RDFS.RANGE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SEEALSO, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SEEALSO, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SEEALSO, RDFS.DOMAIN, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SEEALSO, RDFS.RANGE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SEEALSO, RDFS.SUBPROPERTYOF, RDFS.SEEALSO);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBCLASSOF, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBCLASSOF, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBCLASSOF, RDFS.DOMAIN, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBCLASSOF, RDFS.RANGE, RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBCLASSOF, RDFS.SUBPROPERTYOF, RDFS.SUBCLASSOF);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBPROPERTYOF, RDF.TYPE, RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBPROPERTYOF, RDF.TYPE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBPROPERTYOF, RDFS.DOMAIN, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBPROPERTYOF, RDFS.RANGE, RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement(RDFS.SUBPROPERTYOF, RDFS.SUBPROPERTYOF, RDFS.SUBPROPERTYOF);
        this.processForSchemaCache(statement);
        this.addInferredStatementInternal(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
    }

    @Override
    public void rollback() throws SailException {
        super.rollback();
        if (this.statementsAdded || this.statementsRemoved || this.schemaChange) {
            this.sail.clearInferenceTables();
            this.regenerateCacheAndInferenceMaps(false);
        }
        this.statementsRemoved = false;
        this.statementsAdded = false;
        this.schemaChange = false;
        this.sail.releaseExclusiveWriteLock();
    }

    @Override
    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    @Override
    public void begin(IsolationLevel level) throws SailException {
        IsolationLevel compatibleLevel;
        if (level == null) {
            level = this.sail.getDefaultIsolationLevel();
        }
        if ((compatibleLevel = IsolationLevels.getCompatibleIsolationLevel(level, this.sail.getSupportedIsolationLevels())) == null) {
            throw new UnknownSailTransactionStateException("Isolation level " + level + " not compatible with this Sail");
        }
        super.begin(compatibleLevel);
        this.schemaChange = false;
    }

    @Override
    public void flushUpdates() throws SailException {
        if (this.statementsRemoved) {
            logger.debug("full recomputation needed, starting inferencing from scratch");
            this.clearInferred(new Resource[0]);
            super.flushUpdates();
            this.addAxiomStatements();
            super.flushUpdates();
            this.doInferencing();
            super.flushUpdates();
        } else if (this.statementsAdded) {
            super.flushUpdates();
            this.doInferencing();
        } else {
            super.flushUpdates();
        }
        this.statementsAdded = false;
        this.statementsRemoved = false;
    }

    @Override
    public void statementAdded(Statement st) {
        this.statementsAdded = true;
    }

    @Override
    public void statementRemoved(Statement st) {
        this.statementsRemoved = true;
        if (!this.schemaChange && this.isSchemaStatement(st)) {
            this.schemaChange = true;
        }
    }

    private boolean isSchemaStatement(Statement st) {
        IRI predicate = st.getPredicate();
        return this.schemaPredicates.contains(predicate);
    }

    @Override
    public void addStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.addStatement(false, subj, pred, obj, contexts);
        super.addStatement(modify, subj, pred, obj, contexts);
    }
}

