/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.Changeset;
import org.eclipse.rdf4j.sail.base.DelegatingSailDataset;
import org.eclipse.rdf4j.sail.base.ObservingSailDataset;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailDatasetImpl;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SailSourceBranch
implements SailSource {
    private static final Logger logger = LoggerFactory.getLogger(SailSourceBranch.class);
    private final ReentrantLock semaphore = new ReentrantLock();
    private final ArrayDeque<Changeset> changes = new ArrayDeque();
    private final Collection<Changeset> pending = new ArrayList<Changeset>();
    private final Collection<SailDataset> observers = new ArrayList<SailDataset>();
    private final SailSource backingSource;
    private final ModelFactory modelFactory;
    private final boolean autoFlush;
    private SailDataset snapshot;
    private SailSink serializable;
    private SailSink prepared;

    public SailSourceBranch(SailSource backingSource) {
        this(backingSource, new DynamicModelFactory(), false);
    }

    public SailSourceBranch(SailSource backingSource, ModelFactory modelFactory) {
        this(backingSource, modelFactory, false);
    }

    public SailSourceBranch(SailSource backingSource, ModelFactory modelFactory, boolean autoFlush) {
        this.backingSource = backingSource;
        this.modelFactory = modelFactory;
        this.autoFlush = autoFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SailException {
        this.semaphore.lock();
        try {
            try {
                try {
                    SailDataset toCloseSnapshot = this.snapshot;
                    this.snapshot = null;
                    if (toCloseSnapshot != null) {
                        toCloseSnapshot.close();
                    }
                }
                finally {
                    SailSink toCloseSerializable = this.serializable;
                    this.serializable = null;
                    if (toCloseSerializable != null) {
                        toCloseSerializable.close();
                    }
                }
            }
            finally {
                SailSink toClosePrepared = this.prepared;
                this.prepared = null;
                if (toClosePrepared != null) {
                    toClosePrepared.close();
                }
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    @Override
    public SailSink sink(IsolationLevel level) throws SailException {
        Changeset changeset = new Changeset(){
            private boolean prepared;

            @Override
            public void prepare() throws SailException {
                if (!this.prepared) {
                    SailSourceBranch.this.preparedChangeset(this);
                    this.prepared = true;
                }
                super.prepare();
            }

            @Override
            public void flush() throws SailException {
                SailSourceBranch.this.merge(this);
            }

            @Override
            public void close() throws SailException {
                try {
                    super.close();
                }
                finally {
                    if (this.prepared) {
                        SailSourceBranch.this.closeChangeset(this);
                        this.prepared = false;
                    }
                    SailSourceBranch.this.autoFlush();
                }
            }

            @Override
            public Model createEmptyModel() {
                return SailSourceBranch.this.modelFactory.createEmptyModel();
            }
        };
        try {
            this.semaphore.lock();
            this.pending.add(changeset);
        }
        finally {
            this.semaphore.unlock();
        }
        return changeset;
    }

    @Override
    public SailDataset dataset(IsolationLevel level) throws SailException {
        DelegatingSailDataset dataset = new DelegatingSailDataset(this.derivedFromSerializable(level)){

            @Override
            public void close() throws SailException {
                super.close();
                try {
                    SailSourceBranch.this.semaphore.lock();
                    SailSourceBranch.this.observers.remove(this);
                    SailSourceBranch.this.compressChanges();
                    SailSourceBranch.this.autoFlush();
                }
                finally {
                    SailSourceBranch.this.semaphore.unlock();
                }
            }
        };
        try {
            this.semaphore.lock();
            this.observers.add(dataset);
        }
        finally {
            this.semaphore.unlock();
        }
        return dataset;
    }

    @Override
    public SailSource fork() {
        return new SailSourceBranch(this, this.modelFactory);
    }

    @Override
    public void prepare() throws SailException {
        try {
            this.semaphore.lock();
            if (!this.changes.isEmpty()) {
                if (this.prepared == null && this.serializable == null) {
                    this.prepared = this.backingSource.sink(IsolationLevels.NONE);
                } else if (this.prepared == null) {
                    this.prepared = this.serializable;
                }
                this.prepare(this.prepared);
                this.prepared.prepare();
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    @Override
    public void flush() throws SailException {
        block8: {
            try {
                this.semaphore.lock();
                if (this.changes.isEmpty()) break block8;
                if (this.prepared == null) {
                    this.prepare();
                }
                this.flush(this.prepared);
                this.prepared.flush();
                try {
                    if (this.prepared != this.serializable) {
                        this.prepared.close();
                    }
                }
                finally {
                    this.prepared = null;
                }
            }
            finally {
                this.semaphore.unlock();
            }
        }
    }

    public boolean isChanged() {
        try {
            this.semaphore.lock();
            boolean bl = !this.changes.isEmpty();
            return bl;
        }
        finally {
            this.semaphore.unlock();
        }
    }

    public String toString() {
        return this.backingSource.toString() + "\n" + this.changes.toString();
    }

    void preparedChangeset(Changeset changeset) {
        this.semaphore.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(Changeset change) {
        try {
            this.semaphore.lock();
            this.pending.remove(change);
            if (this.isChanged(change)) {
                this.changes.add(change);
                this.compressChanges();
                Changeset merged = this.changes.getLast();
                for (Changeset c : this.pending) {
                    c.prepend(merged);
                }
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void compressChanges() {
        try {
            this.semaphore.lock();
            while (this.changes.size() > 1) {
                Changeset pop = this.changes.removeLast();
                if (this.changes.peekLast().isRefback()) {
                    this.changes.addLast(pop);
                    return;
                }
                try {
                    this.prepare(pop, this.changes.getLast());
                    this.flush(pop, this.changes.getLast());
                }
                catch (SailException e) {
                    throw new AssertionError((Object)e);
                    return;
                }
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    void closeChangeset(Changeset changeset) {
        this.semaphore.unlock();
    }

    void autoFlush() throws SailException {
        if (this.autoFlush && this.semaphore.tryLock()) {
            try {
                if (this.observers.isEmpty()) {
                    this.flush();
                }
            }
            finally {
                this.semaphore.unlock();
            }
        }
    }

    private boolean isChanged(Changeset change) {
        return change.isChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SailDataset derivedFromSerializable(IsolationLevel level) throws SailException {
        try {
            this.semaphore.lock();
            if (this.serializable == null && level.isCompatibleWith(IsolationLevels.SERIALIZABLE)) {
                this.serializable = this.backingSource.sink(level);
            }
            SailDataset derivedFrom = this.derivedFromSnapshot(level);
            if (this.serializable == null) {
                SailDataset sailDataset = derivedFrom;
                return sailDataset;
            }
            ObservingSailDataset observingSailDataset = new ObservingSailDataset(derivedFrom, this.sink(level));
            return observingSailDataset;
        }
        finally {
            this.semaphore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SailDataset derivedFromSnapshot(IsolationLevel level) throws SailException {
        try {
            SailDataset derivedFrom;
            this.semaphore.lock();
            if (this.snapshot != null) {
                derivedFrom = new DelegatingSailDataset(this.snapshot){

                    @Override
                    public void close() throws SailException {
                    }
                };
            } else {
                derivedFrom = this.backingSource.dataset(level);
                if (level.isCompatibleWith(IsolationLevels.SNAPSHOT)) {
                    this.snapshot = derivedFrom;
                    derivedFrom = new DelegatingSailDataset(derivedFrom){

                        @Override
                        public void close() throws SailException {
                        }
                    };
                }
            }
            Iterator<Changeset> iter = this.changes.iterator();
            while (iter.hasNext()) {
                derivedFrom = new SailDatasetImpl(derivedFrom, iter.next());
            }
            SailDataset sailDataset = derivedFrom;
            return sailDataset;
        }
        finally {
            this.semaphore.unlock();
        }
    }

    private void prepare(SailSink sink) throws SailException {
        try {
            this.semaphore.lock();
            Iterator<Changeset> iter = this.changes.iterator();
            while (iter.hasNext()) {
                this.prepare(iter.next(), sink);
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    private void prepare(Changeset change, SailSink sink) throws SailException {
        Set<Changeset.SimpleStatementPattern> observations = change.getObserved();
        if (observations != null) {
            for (Changeset.SimpleStatementPattern p : observations) {
                Resource subj = p.getSubject();
                IRI pred = p.getPredicate();
                Value obj = p.getObject();
                Resource context = p.getContext();
                if (p.isAllContexts()) {
                    sink.observe(subj, pred, obj, new Resource[0]);
                    continue;
                }
                sink.observe(subj, pred, obj, context);
            }
        }
    }

    private void flush(SailSink sink) throws SailException {
        try {
            this.semaphore.lock();
            if (this.changes.size() == 1 && !this.changes.getFirst().isRefback() && sink instanceof Changeset && !this.isChanged((Changeset)sink)) {
                Changeset dst = (Changeset)sink;
                dst.setChangeset(this.changes.pop());
            } else {
                Iterator<Changeset> iter = this.changes.iterator();
                while (iter.hasNext()) {
                    this.flush(iter.next(), sink);
                    iter.remove();
                }
            }
        }
        finally {
            this.semaphore.unlock();
        }
    }

    private void flush(Changeset change, SailSink sink) throws SailException {
        List<Statement> approved;
        List<Statement> list;
        Set<Resource> set;
        Map<String, String> addedNamespaces;
        Set<String> removedPrefixes;
        this.prepare(change, sink);
        if (change.isNamespaceCleared()) {
            sink.clearNamespaces();
        }
        if ((removedPrefixes = change.getRemovedPrefixes()) != null) {
            for (String string : removedPrefixes) {
                sink.removeNamespace(string);
            }
        }
        if ((addedNamespaces = change.getAddedNamespaces()) != null) {
            for (Map.Entry<String, String> entry : addedNamespaces.entrySet()) {
                sink.setNamespace(entry.getKey(), entry.getValue());
            }
        }
        if (change.isStatementCleared()) {
            sink.clear(new Resource[0]);
        }
        if ((set = change.getDeprecatedContexts()) != null && !set.isEmpty()) {
            sink.clear(set.toArray(new Resource[0]));
        }
        if ((list = change.getDeprecatedStatements()) != null) {
            for (Statement st : list) {
                sink.deprecate(st);
            }
        }
        if ((approved = change.getApprovedStatements()) != null) {
            for (Statement st : approved) {
                sink.approve(st);
            }
        }
    }
}

